/******/ (() => { // webpackBootstrap
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
// 内容脚本 - 处理支付页面的自动化操作
console.log('[支付自动化] 脚本已加载，当前URL:', window.location.href);
console.log('[支付自动化] 页面标题:', document.title);
console.log('[支付自动化] 脚本加载时间:', new Date().toISOString());

// 全局变量：存储批量支付状态
var globalBatchPaymentStatus = null;

// 新增：监听来自父窗口的消息
window.addEventListener('message', function (event) {
  try {
    var data = event.data || {};

    // 处理批量支付状态响应
    if (data.type === 'BATCH_PAYMENT_STATUS_RESPONSE' && data.source === 'batchPaymentManager') {
      globalBatchPaymentStatus = data.isProcessing;
      console.log('[支付自动化] 收到批量支付状态响应:', data.isProcessing);
      return;
    }

    // 处理支付 ACK
    if (data.type === 'PAYMENT_ACK') {
      var ackOrderSn = data.orderSn || '';
      var currentSn = function () {
        try {
          return new URLSearchParams(window.location.search).get('order_sn') || '';
        } catch (_) {
          return '';
        }
      }() || function () {
        try {
          var MARK = 'PDDPAY:';
          if (window.name && window.name.indexOf(MARK) !== -1) {
            var _data = JSON.parse(window.name.slice(window.name.indexOf(MARK) + MARK.length));
            return (_data === null || _data === void 0 ? void 0 : _data.order_sn) || '';
          }
        } catch (_) {
          return '';
        }
        return '';
      }();
      if (!ackOrderSn || ackOrderSn === currentSn) {
        window.__PDD_PAYMENT_ACKED__ = true;
        console.log('[支付自动化] 收到父窗口ACK，订单号:', ackOrderSn || currentSn);
      }
    }
  } catch (e) {
    console.warn('[支付自动化] 处理父窗口消息时异常:', e);
  }
});

// 尝试将订单号持久化到 window.name，便于跨域跳转后仍能获取
(function persistOrderSnToWindowName() {
  try {
    var params = new URLSearchParams(window.location.search);
    var sn = params.get('order_sn');
    if (sn) {
      var MARK = 'PDDPAY:';
      // 若未写入或内容不同，则写入标记
      if (!window.name || window.name.indexOf(MARK) === -1 || !window.name.includes(sn)) {
        var payload = {
          order_sn: sn,
          ts: Date.now()
        };
        window.name = "".concat(MARK).concat(JSON.stringify(payload));
        console.log('[支付自动化] 已将订单号写入 window.name:', sn);
      }
    }
  } catch (e) {
    console.warn('[支付自动化] 写入 window.name 失败:', e);
  }
})();

// 用于在成功页上“等页面加载后”再上报的调度器
function scheduleReportOnSuccessPage() {
  var reason = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'early-detect';
  var trigger = function trigger() {
    if (!window.__PDD_PAYMENT_SUCCESS_REPORTED__) {
      console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u6210\u529F\u9875\u8C03\u5EA6\uFF08".concat(reason, "\uFF09\u89E6\u53D1\uFF0C\u51C6\u5907\u4E0A\u62A5"));
      handlePaymentSuccess();
    }
  };
  if (document.readyState === 'complete') {
    // 页面已完全加载，轻微延迟，确保注入完成
    setTimeout(trigger, 200);
  } else if (document.readyState === 'interactive') {
    // DOM 基本就绪，稍作等待
    setTimeout(trigger, 300);
  } else {
    // 等待DOMContentLoaded或load事件，另加兜底定时器避免遗漏
    var once = {
      once: true
    };
    window.addEventListener('DOMContentLoaded', function () {
      return setTimeout(trigger, 200);
    }, once);
    window.addEventListener('load', function () {
      return setTimeout(trigger, 0);
    }, once);
    setTimeout(function () {
      console.log('[支付自动化] 成功页调度兜底定时器触发');
      trigger();
    }, 2500);
  }
}

// 在极早阶段即识别收银台成功页（避免错过注入/重定向）
try {
  if (window.location.href.includes('mclient.alipay.com/h5pay/cashierActivity')) {
    console.log('[支付自动化] 早期检测到收银台成功页，等待页面加载后再上报');
    // 避免重复上报
    if (!window.__PDD_PAYMENT_SUCCESS_REPORTED__) {
      scheduleReportOnSuccessPage('document_start');
    }
  }
} catch (e) {
  console.warn('[支付自动化] 早期成功页检测异常:', e);
}
chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
  console.log('[支付自动化] 收到消息:', request);
  try {
    if (request.action === 'clickPayButton') {
      console.log('[支付自动化] 开始执行点击支付按钮');
      var result = clickPayButton();
      console.log('[支付自动化] 点击支付按钮结果:', result);
      sendResponse({
        success: result
      });
      return false; // 同步响应，不需要保持通道开放
    } else if (request.action === 'clickConfirmPayment') {
      console.log('[支付自动化] 开始执行点击确认支付');
      var _result = clickConfirmPaymentButton();
      console.log('[支付自动化] 点击确认支付结果:', _result);
      sendResponse({
        success: _result
      });
      return false; // 同步响应
    } else if (request.action === 'inputPaymentPassword') {
      console.log('[支付自动化] 开始输入支付密码');
      var success = enhancedInputPassword(request.password);
      console.log('[支付自动化] 输入密码结果:', success);
      sendResponse({
        success: success
      });
      return false; // 同步响应
    } else if (request.action === 'checkPaymentStatus') {
      console.log('[支付自动化] 检查支付状态');
      var isSuccess = checkPaymentSuccess();
      console.log('[支付自动化] 支付状态检查结果:', isSuccess);
      sendResponse({
        success: isSuccess
      });
      return false; // 同步响应
    }

    // 未知消息类型
    console.log('[支付自动化] 未知消息类型:', request.action);
    sendResponse({
      success: false,
      error: '未知消息类型'
    });
    return false;
  } catch (error) {
    console.error('[支付自动化] 处理消息时发生错误:', error);
    sendResponse({
      success: false,
      error: error.message
    });
    return false;
  }
});

// 自动选择支付宝支付
function selectAlipayPayment() {
  console.log('[支付自动化] 开始选择支付宝支付方式');

  // 使用提供的 XPath 查找支付宝支付选项
  var alipayXpath = '//*[@id="main"]/div[1]/div[7]/div[2]/div/div/div/span[2]';
  var result = document.evaluate(alipayXpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
  var alipayOption = result.singleNodeValue;
  if (alipayOption) {
    console.log('[支付自动化] 找到支付宝支付选项，准备点击');
    alipayOption.click();
    console.log('[支付自动化] 支付宝支付选项已点击');
    return true;
  }

  // 备用方案：通过其他方式查找支付宝选项
  var alternativeSelectors = ['span[class*="alipay"]', 'div[class*="alipay"]', '*[data-payment="alipay"]', '*[data-type="alipay"]', 'span',
  // 查找所有 span 元素
  'div' // 查找所有 div 元素
  ];
  for (var _i = 0, _alternativeSelectors = alternativeSelectors; _i < _alternativeSelectors.length; _i++) {
    var selector = _alternativeSelectors[_i];
    try {
      var elements = document.querySelectorAll(selector);
      var _iterator = _createForOfIteratorHelper(elements),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var element = _step.value;
          var text = (element.textContent || element.innerText || '').trim();
          // 检查是否包含支付宝相关文字
          if (text.includes('支付宝') || text.includes('alipay') || text.includes('Alipay')) {
            // 检查元素是否可见且可点击
            var isVisible = element.offsetWidth > 0 && element.offsetHeight > 0 && window.getComputedStyle(element).display !== 'none' && window.getComputedStyle(element).visibility !== 'hidden';
            if (isVisible) {
              console.log('[支付自动化] 通过备用方案找到支付宝选项:', text);
              element.click();
              console.log('[支付自动化] 支付宝选项已点击（备用方案）');
              return true;
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    } catch (e) {
      console.warn('[支付自动化] 备用选择器失败:', selector, e);
    }
  }
  console.log('[支付自动化] 未找到支付宝支付选项');
  return false;
}

// 点击支付按钮
function clickPayButton() {
  console.log('[支付自动化] clickPayButton 函数开始执行');
  console.log('[支付自动化] 当前页面URL:', window.location.href);
  console.log('[支付自动化] 页面标题:', document.title);

  // 在点击支付按钮前先选择支付宝支付
  console.log('[支付自动化] 点击支付按钮前先选择支付宝支付');
  var alipaySelected = selectAlipayPayment();
  if (alipaySelected) {
    console.log('[支付自动化] 支付宝支付方式已选择，继续点击支付按钮');
  } else {
    console.log('[支付自动化] 未能选择支付宝支付方式，继续点击支付按钮');
  }

  // 策略1: 使用原有的 data-active="red" 方式（优先，单商品订单）
  console.log('[支付自动化] 策略1: 查找 div[data-active="red"] 且文本包含"去支付"');
  var candidates = document.querySelectorAll('div[data-active="red"]');
  console.log('[支付自动化] 找到 div[data-active="red"] 元素数量:', candidates.length);
  var payButton = Array.from(candidates).find(function (el) {
    var text = (el.textContent || el.innerText || '').trim();
    return text.includes('去支付');
  });
  if (payButton) {
    console.log('[支付自动化] 找到支付按钮（策略1: data-active），准备点击:', {
      textContent: payButton.textContent,
      className: payButton.className,
      offsetWidth: payButton.offsetWidth,
      offsetHeight: payButton.offsetHeight
    });
    payButton.click();
    console.log('[支付自动化] 支付按钮已点击（策略1）');
    return true;
  }
  console.log('[支付自动化] 策略1未找到按钮，尝试策略2');

  // 策略2: 通用文本搜索作为备用方案
  console.log('[支付自动化] 策略2: 通用文本搜索');
  var allButtons = document.querySelectorAll('button, div[role="button"], div.button, div[class*="button"]');
  console.log('[支付自动化] 找到所有按钮元素数量:', allButtons.length);
  var _iterator2 = _createForOfIteratorHelper(allButtons),
    _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var btn = _step2.value;
      var _text = (btn.textContent || btn.innerText || '').trim();
      if (_text.includes('去支付') || _text === '支付') {
        var isVisible = btn.offsetWidth > 0 && btn.offsetHeight > 0 && window.getComputedStyle(btn).display !== 'none' && window.getComputedStyle(btn).visibility !== 'hidden';
        if (isVisible) {
          console.log('[支付自动化] 通过策略2找到支付按钮:', {
            textContent: _text,
            tagName: btn.tagName,
            className: btn.className
          });
          btn.click();
          console.log('[支付自动化] 支付按钮已点击（策略2）');
          return true;
        }
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
  console.log('[支付自动化] 策略2未找到按钮，尝试策略3');

  // 策略3: 使用 XPath 查找多商品订单的支付按钮（最终备选方案）
  console.log('[支付自动化] 策略3（最终备选）: 通过 XPath 查找支付按钮（多商品订单）');
  try {
    var xpath = '//*[@id="main"]/div[6]/div[2]';
    var result = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
    var xpathButton = result.singleNodeValue;
    if (xpathButton) {
      var text = (xpathButton.textContent || xpathButton.innerText || '').trim();
      console.log('[支付自动化] 通过 XPath 找到按钮:', {
        xpath: xpath,
        textContent: text,
        className: xpathButton.className
      });

      // 验证是否包含"去支付"或"支付"文本
      if (text.includes('去支付') || text.includes('支付')) {
        console.log('[支付自动化] XPath 按钮文本验证通过，准备点击');
        xpathButton.click();
        console.log('[支付自动化] 支付按钮已点击（策略3: XPath）');
        return true;
      } else {
        console.log('[支付自动化] XPath 找到的按钮文本不符合:', text);
      }
    } else {
      console.log('[支付自动化] 未通过 XPath 找到按钮');
    }
  } catch (e) {
    console.warn('[支付自动化] XPath 查找失败:', e);
  }
  console.log('[支付自动化] 所有策略均未找到支付按钮');
  return false;
}

// 点击确认付款按钮
function clickConfirmPaymentButton() {
  console.log('[支付自动化] clickConfirmPaymentButton 函数开始执行');
  console.log('[支付自动化] 当前页面URL:', window.location.href);
  console.log('[支付自动化] 页面标题:', document.title);
  var xpath = '/html/body/div[2]/div[3]/div[2]/button';
  var result = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
  var confirmButton = result.singleNodeValue;
  console.log('[支付自动化] XPath 查找 cashierPreConfirm 按钮结果:', !!confirmButton, 'XPath:', xpath);
  if (!confirmButton) {
    console.log('[支付自动化] 未通过 XPath 找到确认付款按钮');
    return false;
  }
  setTimeout(function () {
    // 点亮“确认支付”步骤
    sendMessageToParent({
      type: 'PAYMENT_STEP_UPDATE',
      step: 'confirm_payment'
    });
    confirmButton.click();
    console.log('[支付自动化] 确认付款按钮已点击 (XPath)');
    // 点击后开始监听页面重定向到密码输入页面
    setTimeout(function () {
      console.log('[支付自动化] 开始监听页面重定向到密码输入页面');
      waitForPageRedirect();
    }, 200);
  }, 200);
  return true;
}

// 输入支付密码（保留原有方法作为备用）
function inputPassword(password) {
  setTimeout(function () {
    // 查找密码输入框
    var passwordContainer = document.querySelector('div.my-passcode-input.length-6');
    if (passwordContainer) {
      console.log('找到密码输入框，准备输入密码');

      // 模拟点击激活输入框
      passwordContainer.click();
      setTimeout(function () {
        // 创建粘贴事件
        var pasteEvent = new ClipboardEvent('paste', {
          clipboardData: new DataTransfer(),
          bubbles: true,
          cancelable: true
        });

        // 设置粘贴内容
        pasteEvent.clipboardData.setData('text/plain', password);

        // 触发粘贴事件
        passwordContainer.dispatchEvent(pasteEvent);

        // 备用方案：模拟键盘输入
        if (!pasteEvent.defaultPrevented) {
          simulateKeyboardInput(passwordContainer, password);
        }
      }, 500);
    } else {
      console.log('未找到密码输入框');
      // 尝试其他可能的输入方式
      tryAlternativePasswordInput(password);
    }
  }, 2000);
}

// 模拟键盘输入
function simulateKeyboardInput(element, text) {
  element.focus();
  for (var i = 0; i < text.length; i++) {
    var _char = text[i];

    // 创建键盘事件
    var keydownEvent = new KeyboardEvent('keydown', {
      key: _char,
      code: 'Digit' + _char,
      keyCode: _char.charCodeAt(0),
      which: _char.charCodeAt(0),
      bubbles: true
    });
    var inputEvent = new InputEvent('input', {
      data: _char,
      inputType: 'insertText',
      bubbles: true
    });
    var keyupEvent = new KeyboardEvent('keyup', {
      key: _char,
      code: 'Digit' + _char,
      keyCode: _char.charCodeAt(0),
      which: _char.charCodeAt(0),
      bubbles: true
    });
    element.dispatchEvent(keydownEvent);
    element.dispatchEvent(inputEvent);
    element.dispatchEvent(keyupEvent);
  }
}

// 备用密码输入方案
function tryAlternativePasswordInput(password) {
  // 查找所有可能的密码输入框
  var inputs = document.querySelectorAll('input[type="password"], input[type="tel"], input[type="number"], .password-input, .passcode-input');
  var _iterator3 = _createForOfIteratorHelper(inputs),
    _step3;
  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var input = _step3.value;
      if (input.offsetParent !== null) {
        // 检查元素是否可见
        console.log('尝试备用输入框');
        input.focus();
        input.value = password;

        // 触发各种可能的事件
        input.dispatchEvent(new Event('input', {
          bubbles: true
        }));
        input.dispatchEvent(new Event('change', {
          bubbles: true
        }));
        input.dispatchEvent(new Event('blur', {
          bubbles: true
        }));
        break;
      }
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }
}

// 检查是否需要自动支付
function shouldAutoPayment() {
  var urlParams = new URLSearchParams(window.location.search);
  var hasAutoPaymentParam = urlParams.has('auto_payment') && urlParams.get('auto_payment') === '1';
  console.log('[自动支付] 当前URL:', window.location.href);
  console.log('[自动支付] URL参数:', window.location.search);
  console.log('[自动支付] auto_payment参数值:', urlParams.get('auto_payment'));

  // 如果当前URL没有auto_payment参数，尝试从referer中获取
  if (!hasAutoPaymentParam) {
    var refererParam = urlParams.get('referer');
    if (refererParam) {
      try {
        // 解码referer参数并检查其中的auto_payment
        var decodedReferer = decodeURIComponent(refererParam);
        var refererUrl = new URL(decodedReferer);
        var refererAutoPayment = refererUrl.searchParams.get('auto_payment');
        hasAutoPaymentParam = refererAutoPayment === '1';
        console.log('[自动支付] 从referer中提取auto_payment参数:', refererAutoPayment);
        console.log('[自动支付] referer URL:', decodedReferer);
      } catch (e) {
        console.warn('[自动支付] 解析referer参数失败:', e);
      }
    }
  }
  console.log('[自动支付] hasAutoPaymentParam:', hasAutoPaymentParam);
  if (!hasAutoPaymentParam) {
    console.log('[自动支付] 未检测到auto_payment=1参数，不允许自动支付');
    return false;
  }

  // 检查是否为批量支付模式
  var isBatchProcessing = isBatchPaymentProcessing();
  console.log('[自动支付] URL参数检查 - auto_payment=1:', hasAutoPaymentParam);
  console.log('[自动支付] 批量支付状态检查:', isBatchProcessing);

  // 如果能够访问到批量支付状态，则以此为准
  if (isBatchProcessing) {
    console.log('[自动支付] 检测到批量支付正在处理中，允许自动支付');
    return true;
  }

  // 如果无法访问批量支付状态，但有auto_payment参数，则认为是批量支付触发的
  // 这是一个备用方案，因为批量支付会设置这个参数
  console.log('[自动支付] 无法确认批量支付状态，但检测到auto_payment参数，允许自动支付');
  return true;
}

// 获取支付密码 - 从URL参数或chrome.storage中获取
function getPaymentPassword() {
  return _getPaymentPassword.apply(this, arguments);
} // 检查是否需要保持窗口打开（用于调试）
function _getPaymentPassword() {
  _getPaymentPassword = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
    var urlParams, urlPassword, result;
    return _regeneratorRuntime().wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          urlParams = new URLSearchParams(window.location.search);
          urlPassword = urlParams.get('payment_password');
          if (!urlPassword) {
            _context4.next = 4;
            break;
          }
          return _context4.abrupt("return", decodeURIComponent(urlPassword));
        case 4:
          _context4.prev = 4;
          _context4.next = 7;
          return chrome.storage.local.get('alipayPaymentPassword');
        case 7:
          result = _context4.sent;
          return _context4.abrupt("return", result.alipayPaymentPassword || '');
        case 11:
          _context4.prev = 11;
          _context4.t0 = _context4["catch"](4);
          console.log('[支付自动化] 从storage获取密码失败:', _context4.t0);
          return _context4.abrupt("return", '');
        case 15:
        case "end":
          return _context4.stop();
      }
    }, _callee4, null, [[4, 11]]);
  }));
  return _getPaymentPassword.apply(this, arguments);
}
function shouldKeepWindowOpen() {
  var urlParams = new URLSearchParams(window.location.search);
  return urlParams.has('keep_window_open') && urlParams.get('keep_window_open') === '1';
}

// 检查是否为批量支付模式
function isBatchPaymentMode() {
  var urlParams = new URLSearchParams(window.location.search);
  return urlParams.has('auto_payment') && urlParams.get('auto_payment') === '1';
}

// 检查批量支付是否正在处理中
function isBatchPaymentProcessing() {
  try {
    // 首先尝试直接访问（同域情况）
    if (window.opener && window.opener.orderManager && window.opener.orderManager.batchPaymentManager) {
      var isProcessing = window.opener.orderManager.batchPaymentManager.isProcessing;
      console.log('[支付自动化] 批量支付状态检查 - 直接访问 isProcessing:', isProcessing);
      return isProcessing;
    }

    // 如果有缓存的状态，直接返回
    if (globalBatchPaymentStatus !== null) {
      console.log('[支付自动化] 批量支付状态检查 - 使用缓存状态:', globalBatchPaymentStatus);
      return globalBatchPaymentStatus;
    }

    // 如果直接访问失败且没有缓存状态，使用 postMessage 机制（跨域情况）
    if (window.opener) {
      console.log('[支付自动化] 使用 postMessage 请求批量支付状态');
      // 发送消息请求批量支付状态
      window.opener.postMessage({
        type: 'REQUEST_BATCH_PAYMENT_STATUS',
        source: 'paymentAutomation'
      }, '*');

      // 返回 false，等待异步响应更新状态
      return false;
    }
    console.log('[支付自动化] 批量支付状态检查 - 无法访问父窗口');
    return false;
  } catch (error) {
    console.warn('[支付自动化] 无法访问批量支付状态:', error);

    // 如果有缓存的状态，使用缓存状态
    if (globalBatchPaymentStatus !== null) {
      console.log('[支付自动化] 批量支付状态检查 - 异常时使用缓存状态:', globalBatchPaymentStatus);
      return globalBatchPaymentStatus;
    }

    // 跨域错误时，尝试使用 postMessage
    if (window.opener) {
      console.log('[支付自动化] 跨域错误，使用 postMessage 请求批量支付状态');
      window.opener.postMessage({
        type: 'REQUEST_BATCH_PAYMENT_STATUS',
        source: 'paymentAutomation'
      }, '*');
      return false;
    }
    return false;
  }
}

// 获取订单号
function getOrderSn() {
  var urlParams = new URLSearchParams(window.location.search);
  var fromUrl = urlParams.get('order_sn');
  if (fromUrl) return fromUrl;
  // 从 window.name 回退获取（跨域跳转后使用）
  try {
    var MARK = 'PDDPAY:';
    if (window.name && window.name.indexOf(MARK) !== -1) {
      var jsonStr = window.name.slice(window.name.indexOf(MARK) + MARK.length);
      try {
        var data = JSON.parse(jsonStr);
        if (data && data.order_sn) {
          return data.order_sn;
        }
      } catch (e) {
        // 忽略 JSON 解析错误
      }
    }
  } catch (e) {
    console.warn('[支付自动化] 从 window.name 解析订单号失败:', e);
  }
  return '';
}

// 发送消息给父窗口
function sendMessageToParent(data) {
  try {
    if (window.opener && !window.opener.closed) {
      window.opener.postMessage(data, '*');
    }
  } catch (error) {
    console.error('发送消息给父窗口失败:', error);
  }
}

// 显示自动化进度提示
function showProgress(message) {
  console.log("[\u81EA\u52A8\u652F\u4ED8] ".concat(message));

  // 创建或更新进度提示元素
  var progressElement = document.getElementById('auto-payment-progress');
  if (!progressElement) {
    progressElement = document.createElement('div');
    progressElement.id = 'auto-payment-progress';
    progressElement.style.cssText = "\n      position: fixed;\n      top: 10px;\n      right: 10px;\n      background: #52c41a;\n      color: white;\n      padding: 10px 15px;\n      border-radius: 6px;\n      font-size: 14px;\n      z-index: 9999;\n      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);\n      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;\n    ";
    document.body.appendChild(progressElement);
  }
  progressElement.textContent = message;
}

// 隐藏进度提示
function hideProgress() {
  var progressElement = document.getElementById('auto-payment-progress');
  if (progressElement) {
    progressElement.remove();
  }
}

// 等待指定时间
function sleep(ms) {
  return new Promise(function (resolve) {
    return setTimeout(resolve, ms);
  });
}

// 订单列表页面的自动支付流程（优化版 - 30%速度提升）
function autoPaymentProcessForOrderSearch() {
  return _autoPaymentProcessForOrderSearch.apply(this, arguments);
} // 从订单搜索结果页面获取订单状态
function _autoPaymentProcessForOrderSearch() {
  _autoPaymentProcessForOrderSearch = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5() {
    var orderStatus, orderSn, canProceed, _orderSn, clickResult, attempts, maxAttempts, waitTime, selectResult, payResult, _orderSn2;
    return _regeneratorRuntime().wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          console.log('[支付自动化] 开始订单列表自动支付流程');
          _context5.prev = 1;
          // 步骤1: 智能等待页面加载 - 优化到800ms（进一步提速33%）
          console.log('[支付自动化] 智能等待页面加载...');
          _context5.next = 5;
          return sleep(800);
        case 5:
          // === 检查订单状态：允许 "待支付" 或含"售罄"继续 ===
          console.log('[支付自动化] 检查订单状态（从页面实时获取）');
          _context5.next = 8;
          return getOrderStatusFromSearchPage();
        case 8:
          orderStatus = _context5.sent;
          if (orderStatus) {
            _context5.next = 14;
            break;
          }
          console.warn('[支付自动化] 无法从页面获取订单状态，跳过该订单');
          orderSn = getOrderSn();
          sendMessageToParent({
            type: 'PAYMENT_RESULT',
            orderSn: orderSn,
            success: false,
            error: '无法从页面获取订单状态'
          });
          return _context5.abrupt("return");
        case 14:
          console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u8BA2\u5355\u72B6\u6001: ".concat(orderStatus));
          canProceed = orderStatus === '待支付' || /售罄/.test(orderStatus);
          if (canProceed) {
            _context5.next = 21;
            break;
          }
          console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u8BA2\u5355\u72B6\u6001\u4E3A\"".concat(orderStatus, "\"\uFF0C\u4E0D\u5728\u53EF\u652F\u4ED8\u8303\u56F4\uFF08\u5F85\u652F\u4ED8\u6216\u552E\u7F44\uFF09\uFF0C\u8DF3\u8FC7\u652F\u4ED8"));
          _orderSn = getOrderSn();
          sendMessageToParent({
            type: 'PAYMENT_RESULT',
            orderSn: _orderSn,
            success: false,
            error: "\u8BA2\u5355\u72B6\u6001\u4E3A\"".concat(orderStatus, "\"\uFF0C\u4E0D\u5728\u53EF\u652F\u4ED8\u8303\u56F4\uFF08\u5F85\u652F\u4ED8\u6216\u552E\u7F44\uFF09"),
            skipped: true
          });
          return _context5.abrupt("return");
        case 21:
          console.log('[支付自动化] 订单状态符合可支付条件，继续支付流程');

          // 步骤2: 优化的按钮点击策略 - 使用更智能的重试间隔
          clickResult = false;
          attempts = 0;
          maxAttempts = 6; // 减少尝试次数从8到6
        case 25:
          if (!(!clickResult && attempts < maxAttempts)) {
            _context5.next = 38;
            break;
          }
          attempts++;
          console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u8BA2\u5355\u5217\u8868\u5C1D\u8BD5\u70B9\u51FB\u53BB\u652F\u4ED8\u6309\u94AE (".concat(attempts, "/").concat(maxAttempts, ")"));
          clickResult = clickPayButtonInOrderSearch();
          if (clickResult) {
            _context5.next = 35;
            break;
          }
          // 优化等待策略：使用渐进式间隔（100ms起步，更快响应）
          waitTime = attempts === 1 ? 100 : 120;
          _context5.next = 33;
          return sleep(waitTime);
        case 33:
          _context5.next = 36;
          break;
        case 35:
          return _context5.abrupt("break", 38);
        case 36:
          _context5.next = 25;
          break;
        case 38:
          if (clickResult) {
            _context5.next = 40;
            break;
          }
          throw new Error('订单列表未找到去支付按钮');
        case 40:
          _context5.next = 42;
          return sleep(350);
        case 42:
          // 步骤4: 选择支付宝支付方式（无等待优化）
          selectResult = selectAlipayPaymentInOrderSearch();
          if (selectResult) {
            console.log('[支付自动化] 订单列表支付宝支付方式已选择');
          }

          // 步骤5: 快速点击立即支付 - 优化到100ms（进一步减少33%）
          _context5.next = 46;
          return sleep(100);
        case 46:
          _context5.next = 48;
          return clickImmediatePayButton();
        case 48:
          payResult = _context5.sent;
          if (payResult) {
            _context5.next = 51;
            break;
          }
          throw new Error('订单列表未找到立即支付按钮');
        case 51:
          // 步骤7: 等待跳转到支付宝（后续流程会自动处理）
          console.log('[支付自动化] 订单列表支付按钮已点击，等待跳转到支付宝');
          _context5.next = 59;
          break;
        case 54:
          _context5.prev = 54;
          _context5.t0 = _context5["catch"](1);
          console.error('[支付自动化] 订单列表自动支付失败:', _context5.t0);
          _orderSn2 = getOrderSn();
          sendMessageToParent({
            type: 'PAYMENT_RESULT',
            orderSn: _orderSn2,
            success: false,
            error: _context5.t0.message
          });
        case 59:
        case "end":
          return _context5.stop();
      }
    }, _callee5, null, [[1, 54]]);
  }));
  return _autoPaymentProcessForOrderSearch.apply(this, arguments);
}
function getOrderStatusFromSearchPage() {
  return _getOrderStatusFromSearchPage.apply(this, arguments);
} // 订单列表页面点击"去支付"按钮
function _getOrderStatusFromSearchPage() {
  _getOrderStatusFromSearchPage = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6() {
    var xpath, xpathResult, statusElement, statusText, baseList, firstOrder, statusP, _statusText;
    return _regeneratorRuntime().wrap(function _callee6$(_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          console.log('[支付自动化] 开始从页面获取订单状态');
          _context6.prev = 1;
          // 使用XPath获取订单状态文本
          // XPath: //*[@id="base-list"]/div[1]/div/div[1]/p 或者 //*[@id="base-list"]/div[1]/div/div[1]/div[3]
          xpath = '//*[@id="base-list"]/div[1]/div/div[1]/p | //*[@id="base-list"]/div[1]/div/div[1]/div[3]';
          xpathResult = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
          statusElement = xpathResult.singleNodeValue;
          if (!statusElement) {
            _context6.next = 9;
            break;
          }
          statusText = statusElement.textContent.trim();
          console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u901A\u8FC7XPath\u83B7\u53D6\u5230\u8BA2\u5355\u72B6\u6001: ".concat(statusText));
          return _context6.abrupt("return", statusText);
        case 9:
          // 备用方案：查找base-list下的第一个订单的状态
          baseList = document.getElementById('base-list');
          if (!baseList) {
            _context6.next = 18;
            break;
          }
          firstOrder = baseList.querySelector('div > div');
          if (!firstOrder) {
            _context6.next = 18;
            break;
          }
          statusP = firstOrder.querySelector('div > p');
          if (!statusP) {
            _context6.next = 18;
            break;
          }
          _statusText = statusP.textContent.trim();
          console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u901A\u8FC7\u5907\u7528\u65B9\u6848\u83B7\u53D6\u5230\u8BA2\u5355\u72B6\u6001: ".concat(_statusText));
          return _context6.abrupt("return", _statusText);
        case 18:
          console.warn('[支付自动化] 无法从页面获取订单状态');
          return _context6.abrupt("return", null);
        case 22:
          _context6.prev = 22;
          _context6.t0 = _context6["catch"](1);
          console.error('[支付自动化] 获取订单状态失败:', _context6.t0);
          return _context6.abrupt("return", null);
        case 26:
        case "end":
          return _context6.stop();
      }
    }, _callee6, null, [[1, 22]]);
  }));
  return _getOrderStatusFromSearchPage.apply(this, arguments);
}
function clickPayButtonInOrderSearch() {
  console.log('[支付自动化] 订单列表开始查找去支付按钮');

  // 使用XPath
  //*[@id="base-list"]/div[1]/div/div[4]/div/a[1]
  var xpath = '//*[@id="base-list"]/div[1]/div/div[4]/div/a[1]';
  var xpathResult = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
  var payButton = xpathResult.singleNodeValue;
  if (payButton) {
    console.log('[支付自动化] 订单列表通过XPath找到去支付按钮');
    payButton.click();
    console.log('[支付自动化] 订单列表去支付按钮已点击');
    return true;
  }

  // 备用方案：通过文本查找
  var allLinks = document.querySelectorAll('a');
  var _iterator4 = _createForOfIteratorHelper(allLinks),
    _step4;
  try {
    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
      var link = _step4.value;
      var text = (link.textContent || link.innerText || '').trim();
      if (text === '去支付') {
        var isVisible = link.offsetWidth > 0 && link.offsetHeight > 0 && window.getComputedStyle(link).display !== 'none' && window.getComputedStyle(link).visibility !== 'hidden';
        if (isVisible) {
          console.log('[支付自动化] 订单列表通过备用方案找到去支付按钮');
          link.click();
          console.log('[支付自动化] 订单列表去支付按钮已点击（备用方案）');
          return true;
        }
      }
    }
  } catch (err) {
    _iterator4.e(err);
  } finally {
    _iterator4.f();
  }
  console.log('[支付自动化] 订单列表未找到去支付按钮');
  return false;
}

// 订单列表页面选择支付宝支付方式
function selectAlipayPaymentInOrderSearch() {
  console.log('[支付自动化] 订单列表开始选择支付宝支付方式');

  // 方法1: 使用精确的XPath（第一优先级）
  var xpath = '//*[@id="pay-method-wrap"]/div/div[2]/div/div/div';
  var xpathResult = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
  var alipayElement = xpathResult.singleNodeValue;
  if (alipayElement) {
    var isVisible = alipayElement.offsetWidth > 0 && alipayElement.offsetHeight > 0 && window.getComputedStyle(alipayElement).display !== 'none' && window.getComputedStyle(alipayElement).visibility !== 'hidden';
    if (isVisible) {
      console.log('[支付自动化] 订单列表通过XPath找到支付宝支付选项');

      // 无论是否已选中，都点击确保选中（第一优先级）
      alipayElement.click();
      console.log('[支付自动化] 订单列表支付宝支付选项已点击（XPath方式）');
      return true;
    } else {
      console.log('[支付自动化] 订单列表通过XPath找到支付宝元素但不可见');
    }
  } else {
    console.log('[支付自动化] 订单列表XPath未找到支付宝元素');
  }

  // 方法2: 备用方案 - 查找包含"支付宝"的元素
  console.log('[支付自动化] 订单列表尝试备用方案查找支付宝');
  var allDivs = document.querySelectorAll('div');
  var _iterator5 = _createForOfIteratorHelper(allDivs),
    _step5;
  try {
    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
      var div = _step5.value;
      var ariaLabel = div.getAttribute('aria-label') || '';

      // 检查aria-label是否包含"支付宝"
      if (ariaLabel.includes('支付宝')) {
        var _isVisible = div.offsetWidth > 0 && div.offsetHeight > 0 && window.getComputedStyle(div).display !== 'none' && window.getComputedStyle(div).visibility !== 'hidden';
        if (_isVisible) {
          console.log('[支付自动化] 订单列表通过备用方案找到支付宝支付选项，aria-label:', ariaLabel);

          // 无论是否已选中，都点击确保选中
          div.click();
          console.log('[支付自动化] 订单列表支付宝支付选项已点击（备用方案）');
          return true;
        }
      }
    }
  } catch (err) {
    _iterator5.e(err);
  } finally {
    _iterator5.f();
  }
  console.log('[支付自动化] 订单列表未找到支付宝支付选项');
  return false;
}

// 订单列表页面点击"立即支付"按钮
function clickImmediatePayButton() {
  return _clickImmediatePayButton.apply(this, arguments);
} // 自动支付流程
function _clickImmediatePayButton() {
  _clickImmediatePayButton = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee7() {
    var xpath, xpathResult, payButton, text, allDivs, _iterator11, _step11, div, _text4, isVisible;
    return _regeneratorRuntime().wrap(function _callee7$(_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          console.log('[支付自动化] 订单列表开始查找立即支付按钮');

          // 使用XPath
          xpath = '//*[@id="modal-root"]/div/div/div/section/div[3]';
          xpathResult = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
          payButton = xpathResult.singleNodeValue;
          if (!payButton) {
            _context7.next = 11;
            break;
          }
          text = (payButton.textContent || payButton.innerText || '').trim();
          console.log('[支付自动化] 订单列表通过XPath找到按钮，文本:', text);
          if (!(text === '立即支付')) {
            _context7.next = 11;
            break;
          }
          payButton.click();
          console.log('[支付自动化] 订单列表立即支付按钮已点击');
          return _context7.abrupt("return", true);
        case 11:
          // 备用方案：通过className和文本查找
          allDivs = document.querySelectorAll('div.pay-confirm-btn');
          _iterator11 = _createForOfIteratorHelper(allDivs);
          _context7.prev = 13;
          _iterator11.s();
        case 15:
          if ((_step11 = _iterator11.n()).done) {
            _context7.next = 27;
            break;
          }
          div = _step11.value;
          _text4 = (div.textContent || div.innerText || '').trim();
          if (!(_text4 === '立即支付')) {
            _context7.next = 25;
            break;
          }
          isVisible = div.offsetWidth > 0 && div.offsetHeight > 0 && window.getComputedStyle(div).display !== 'none' && window.getComputedStyle(div).visibility !== 'hidden';
          if (!isVisible) {
            _context7.next = 25;
            break;
          }
          console.log('[支付自动化] 订单列表通过备用方案找到立即支付按钮');
          div.click();
          console.log('[支付自动化] 订单列表立即支付按钮已点击（备用方案）');
          return _context7.abrupt("return", true);
        case 25:
          _context7.next = 15;
          break;
        case 27:
          _context7.next = 32;
          break;
        case 29:
          _context7.prev = 29;
          _context7.t0 = _context7["catch"](13);
          _iterator11.e(_context7.t0);
        case 32:
          _context7.prev = 32;
          _iterator11.f();
          return _context7.finish(32);
        case 35:
          console.log('[支付自动化] 订单列表未找到立即支付按钮');
          return _context7.abrupt("return", false);
        case 37:
        case "end":
          return _context7.stop();
      }
    }, _callee7, null, [[13, 29, 32, 35]]);
  }));
  return _clickImmediatePayButton.apply(this, arguments);
}
function autoPaymentProcess() {
  return _autoPaymentProcess.apply(this, arguments);
} // 页面加载完成后自动检测
function _autoPaymentProcess() {
  _autoPaymentProcess = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee8() {
    var orderSn, paymentPassword, payResult, attempts, maxAttempts, refundButton, passwordResult, refundButtonAfterPassword, checkCount, maxChecks, _loop5, _ret4, isBatchMode, isProcessing, shouldClose, reason;
    return _regeneratorRuntime().wrap(function _callee8$(_context9) {
      while (1) switch (_context9.prev = _context9.next) {
        case 0:
          orderSn = getOrderSn();
          _context9.next = 3;
          return getPaymentPassword();
        case 3:
          paymentPassword = _context9.sent;
          console.log('[自动支付] 开始自动支付流程', {
            orderSn: orderSn,
            hasPassword: !!paymentPassword
          });
          _context9.prev = 5;
          showProgress('正在查找支付按钮...');

          // 等待页面完全加载 - 增加等待时间
          _context9.next = 9;
          return sleep(5000);
        case 9:
          // 尝试多次查找支付按钮 - 增加重试次数和等待时间
          payResult = false;
          attempts = 0;
          maxAttempts = 10; // 从5次增加到10次
        case 12:
          if (!(!payResult && attempts < maxAttempts)) {
            _context9.next = 33;
            break;
          }
          attempts++;
          showProgress("\u6B63\u5728\u70B9\u51FB\u652F\u4ED8\u6309\u94AE... (\u5C1D\u8BD5 ".concat(attempts, "/").concat(maxAttempts, ")"));
          console.log("[\u81EA\u52A8\u652F\u4ED8] \u7B2C ".concat(attempts, " \u6B21\u5C1D\u8BD5\u70B9\u51FB\u652F\u4ED8\u6309\u94AE"));

          // 先检查是否有已支付订单标识
          refundButton = checkForRefundButton();
          if (!refundButton) {
            _context9.next = 21;
            break;
          }
          console.log("[\u81EA\u52A8\u652F\u4ED8] \u7B2C ".concat(attempts, " \u6B21\u5C1D\u8BD5\u65F6\u68C0\u6D4B\u5230\u5DF2\u652F\u4ED8\u8BA2\u5355\uFF0C\u8DF3\u8FC7\u5F53\u524D\u8BA2\u5355"));
          handleRefundDetected();
          return _context9.abrupt("return");
        case 21:
          payResult = clickPayButton();
          if (payResult) {
            _context9.next = 28;
            break;
          }
          console.log("[\u81EA\u52A8\u652F\u4ED8] \u7B2C ".concat(attempts, " \u6B21\u5C1D\u8BD5\u5931\u8D25\uFF0C\u7B49\u5F851.5\u79D2\u540E\u91CD\u8BD5"));
          _context9.next = 26;
          return sleep(1500);
        case 26:
          _context9.next = 31;
          break;
        case 28:
          console.log("[\u81EA\u52A8\u652F\u4ED8] \u7B2C ".concat(attempts, " \u6B21\u5C1D\u8BD5\u6210\u529F"));
          // 发送步骤更新消息
          sendMessageToParent({
            type: 'PAYMENT_STEP_UPDATE',
            step: 'pay_button_clicked'
          });
          return _context9.abrupt("break", 33);
        case 31:
          _context9.next = 12;
          break;
        case 33:
          if (payResult) {
            _context9.next = 35;
            break;
          }
          throw new Error("\u5C1D\u8BD5 ".concat(maxAttempts, " \u6B21\u540E\u4ECD\u672A\u627E\u5230\u652F\u4ED8\u6309\u94AE"));
        case 35:
          _context9.next = 37;
          return sleep(1000);
        case 37:
          if (!paymentPassword) {
            _context9.next = 60;
            break;
          }
          showProgress('正在输入支付密码...');
          console.log('[自动支付] 开始输入支付密码');
          passwordResult = enhancedInputPassword(paymentPassword);
          if (!passwordResult) {
            _context9.next = 57;
            break;
          }
          console.log('[自动支付] 密码输入成功');
          // 发送步骤更新消息
          sendMessageToParent({
            type: 'PAYMENT_STEP_UPDATE',
            step: 'input_password'
          });
          _context9.next = 46;
          return sleep(2000);
        case 46:
          // 在确认支付前再次检查退款状态
          refundButtonAfterPassword = checkForRefundButton();
          if (!refundButtonAfterPassword) {
            _context9.next = 51;
            break;
          }
          console.log('[自动支付] 密码输入后检测到退款相关按钮，跳过当前订单');
          handleRefundDetected();
          return _context9.abrupt("return");
        case 51:
          // 点击确认支付按钮
          showProgress('正在确认支付...');
          console.log('[自动支付] 开始点击确认支付按钮');
          // 发送步骤更新消息
          sendMessageToParent({
            type: 'PAYMENT_STEP_UPDATE',
            step: 'confirm_payment'
          });
          clickConfirmPaymentButton();
          _context9.next = 58;
          break;
        case 57:
          console.log('[自动支付] 密码输入失败');
        case 58:
          _context9.next = 61;
          break;
        case 60:
          console.log('[自动支付] 无支付密码，跳过密码输入步骤');
        case 61:
          // 等待支付结果
          showProgress('正在等待支付结果...');
          console.log('[自动支付] 开始等待支付结果');

          // 检查支付结果（等待最多60秒）
          checkCount = 0;
          maxChecks = 120; // 60秒，每0.5秒检查一次
          _loop5 = /*#__PURE__*/_regeneratorRuntime().mark(function _loop5() {
            var refundButtonDuringWait, isBatchMode, isProcessing, shouldClose, reason;
            return _regeneratorRuntime().wrap(function _loop5$(_context8) {
              while (1) switch (_context8.prev = _context8.next) {
                case 0:
                  _context8.next = 2;
                  return sleep(500);
                case 2:
                  checkCount++;
                  if (checkCount % 10 === 0) {
                    console.log("[\u81EA\u52A8\u652F\u4ED8] \u652F\u4ED8\u7ED3\u679C\u68C0\u67E5\u8FDB\u5EA6: ".concat(checkCount, "/").concat(maxChecks));
                  }

                  // 在等待支付结果期间检查退款状态
                  refundButtonDuringWait = checkForRefundButton();
                  if (!refundButtonDuringWait) {
                    _context8.next = 9;
                    break;
                  }
                  console.log('[自动支付] 等待支付结果期间检测到退款相关按钮，跳过当前订单');
                  handleRefundDetected();
                  return _context8.abrupt("return", {
                    v: void 0
                  });
                case 9:
                  if (!checkPaymentSuccess()) {
                    _context8.next = 23;
                    break;
                  }
                  showProgress('支付成功！');
                  console.log('[自动支付] 检测到支付成功');

                  // 发送步骤更新消息
                  sendMessageToParent({
                    type: 'PAYMENT_STEP_UPDATE',
                    step: 'payment_success'
                  });

                  // 发送成功消息给父窗口
                  sendMessageToParent({
                    type: 'PAYMENT_RESULT',
                    orderSn: orderSn,
                    success: true,
                    message: '支付成功'
                  });

                  // 判断是否应该关闭窗口
                  isBatchMode = isBatchPaymentMode();
                  isProcessing = isBatchPaymentProcessing();
                  console.log('[自动支付] 支付成功 - 批量支付模式:', isBatchMode, '正在处理中:', isProcessing);
                  shouldClose = false;
                  reason = '';
                  if (shouldKeepWindowOpen()) {
                    // 调试模式，保持窗口打开
                    reason = '调试模式，保持窗口打开';
                  } else if (!isBatchMode) {
                    // 非批量支付模式（手动点击），不关闭窗口
                    reason = '非批量支付模式，保持窗口打开避免突兀';
                  } else if (isBatchMode && isProcessing) {
                    // 批量支付模式且正在处理中，关闭窗口
                    shouldClose = true;
                    reason = '批量支付模式且正在处理中，关闭窗口';
                  } else {
                    // 批量支付模式但未在处理中，关闭窗口
                    shouldClose = true;
                    reason = '批量支付模式但未在处理中，关闭窗口';
                  }
                  console.log('[自动支付] 支付成功窗口关闭决策:', {
                    shouldClose: shouldClose,
                    reason: reason
                  });
                  if (shouldClose) {
                    // 延迟关闭窗口
                    setTimeout(function () {
                      hideProgress();
                      console.log('[自动支付] 关闭窗口:', reason);
                      window.close();
                    }, 2000);
                  } else {
                    console.log('[自动支付] 保持窗口打开:', reason);
                    setTimeout(function () {
                      hideProgress();
                      // 只在调试模式下显示提示信息
                      if (shouldKeepWindowOpen()) {
                        showProgress('支付成功！窗口保持打开以便调试');
                      }
                    }, 2000);
                  }
                  return _context8.abrupt("return", {
                    v: void 0
                  });
                case 23:
                case "end":
                  return _context8.stop();
              }
            }, _loop5);
          });
        case 66:
          if (!(checkCount < maxChecks)) {
            _context9.next = 73;
            break;
          }
          return _context9.delegateYield(_loop5(), "t0", 68);
        case 68:
          _ret4 = _context9.t0;
          if (!_ret4) {
            _context9.next = 71;
            break;
          }
          return _context9.abrupt("return", _ret4.v);
        case 71:
          _context9.next = 66;
          break;
        case 73:
          throw new Error('支付超时，请手动检查支付状态');
        case 76:
          _context9.prev = 76;
          _context9.t1 = _context9["catch"](5);
          console.error('[自动支付] 处理失败:', _context9.t1);
          showProgress("\u652F\u4ED8\u5931\u8D25: ".concat(_context9.t1.message));

          // 发送失败消息给父窗口
          sendMessageToParent({
            type: 'PAYMENT_RESULT',
            orderSn: orderSn,
            success: false,
            error: _context9.t1.message
          });

          // 发送消息给后台脚本，通知支付失败，进入下一个订单
          chrome.runtime.sendMessage({
            action: 'paymentSuccess',
            nextOrder: true,
            reason: 'payment_failed',
            message: "\u652F\u4ED8\u5931\u8D25: ".concat(_context9.t1.message)
          }, function (response) {
            console.log('[支付自动化] 支付失败消息发送结果:', response);
          });

          // 判断是否应该关闭窗口
          isBatchMode = isBatchPaymentMode();
          isProcessing = isBatchPaymentProcessing();
          console.log('[自动支付] 支付失败 - 批量支付模式:', isBatchMode, '正在处理中:', isProcessing);
          shouldClose = false;
          reason = '';
          if (shouldKeepWindowOpen()) {
            // 调试模式，保持窗口打开
            reason = '调试模式，保持窗口打开';
          } else if (!isBatchMode) {
            // 非批量支付模式（手动点击），不关闭窗口
            reason = '非批量支付模式，保持窗口打开避免突兀';
          } else if (isBatchMode && isProcessing) {
            // 批量支付模式且正在处理中，关闭窗口
            shouldClose = true;
            reason = '批量支付模式且正在处理中，关闭窗口';
          } else {
            // 批量支付模式但未在处理中，关闭窗口
            shouldClose = true;
            reason = '批量支付模式但未在处理中，关闭窗口';
          }
          console.log('[自动支付] 支付失败窗口关闭决策:', {
            shouldClose: shouldClose,
            reason: reason
          });
          if (shouldClose) {
            // 延迟关闭窗口
            setTimeout(function () {
              hideProgress();
              console.log('[自动支付] 关闭窗口:', reason);
              window.close();
            }, 3000);
          } else {
            console.log('[自动支付] 保持窗口打开:', reason);
            setTimeout(function () {
              hideProgress();
              // 只在调试模式下显示提示信息
              if (shouldKeepWindowOpen()) {
                showProgress("\u652F\u4ED8\u5931\u8D25: ".concat(_context9.t1.message, "\u3002\u7A97\u53E3\u4FDD\u6301\u6253\u5F00\u4EE5\u4FBF\u8C03\u8BD5"));
              }
            }, 3000);
          }
        case 90:
        case "end":
          return _context9.stop();
      }
    }, _callee8, null, [[5, 76]]);
  }));
  return _autoPaymentProcess.apply(this, arguments);
}
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', autoDetectAndProcess);
} else {
  autoDetectAndProcess();
}

// 自动检测当前页面并执行相应操作
function autoDetectAndProcess() {
  console.log('[支付自动化] 页面加载完成，开始自动检测');
  console.log('[支付自动化] 当前URL:', window.location.href);
  console.log('[支付自动化] 页面标题:', document.title);
  console.log('[支付自动化] shouldAutoPayment()结果:', shouldAutoPayment());
  console.log('[支付自动化] isBatchPaymentProcessing()结果:', isBatchPaymentProcessing());

  // 先获取URL并判断是否为订单详情页或订单列表页
  var url = window.location.href;
  var pathname = window.location.pathname;
  var hostname = window.location.hostname;
  var isOrderDetailPage = pathname.includes('order.html') || pathname.includes('transac_combine_order.html');
  var isOrderSearchResultsPage = hostname.includes('yangkeduo.com') && pathname.includes('transac_orders_search_results.html');

  // 在订单详情页优先检查退款/售后等文字，命中则直接跳过，不检查支付按钮
  if (isOrderDetailPage) {
    console.log('[支付自动化] 检测到订单详情页，优先检查是否为可支付订单');
    setTimeout(function () {
      var refundIndicator = checkForRefundButton();
      if (refundIndicator) {
        console.log('[支付自动化] 订单详情页检测到退款/售后相关文字，直接跳过当前订单');
        handleRefundDetected();
        return;
      }
      console.log('[支付自动化] 未检测到退款/售后文字');
      if (isBatchPaymentProcessing()) {
        console.log('[支付自动化] 批量支付正在处理中，开始监听支付按钮');
        observeForPayButton();
      } else {
        console.log('[支付自动化] 批量支付未在处理中，跳过自动支付监听');
      }
    }, 800);

    // 订单详情页流程在上面的回调中继续处理
    return;
  }

  // 订单列表页面的支付流程
  if (isOrderSearchResultsPage) {
    console.log('[支付自动化] 检测到订单列表页面');

    // 必须同时满足：1. 有batch_payment参数 2. 有auto_payment参数
    var urlParams = new URLSearchParams(window.location.search);
    var hasBatchPayment = urlParams.get('batch_payment') === '1';
    if (hasBatchPayment && shouldAutoPayment()) {
      console.log('[支付自动化] 检测到订单列表批量支付场景，开始自动支付');
      setTimeout(autoPaymentProcessForOrderSearch, 1000);
    } else {
      console.log('[支付自动化] 订单列表非批量支付场景或缺少auto_payment参数，跳过自动支付');
    }
    return;
  }

  // 非订单详情页：在页面加载后先检查是否为已支付/可退款
  setTimeout(function () {
    var refundButton = checkForRefundButton();
    if (refundButton) {
      console.log('[支付自动化] 在页面加载时检测到申请退款/售后/退款完成相关按钮，直接进入下一个订单');
      handleRefundDetected();
      return;
    }
  }, 1000);

  // 支付宝页面判断 - 必须在shouldAutoPayment()之前判断,避免支付宝页面误走拼多多页面流程
  // 支付宝 landing 页面 - 等待重定向
  if (url.includes('mclient.alipay.com/h5pay/landing')) {
    console.log('[支付自动化] 检测到支付宝 landing 页面，等待重定向');
    waitForPageRedirect();
    return;
  }

  // 支付宝确认页面 - 更宽泛的匹配
  if (url.includes('mclient.alipay.com/h5pay/cashierPreConfirm') || url.includes('mclient.alipay.com/h5pay/cashierPreConfirm/index.html')) {
    console.log('[支付自动化] 检测到支付宝确认页面');
    if (isBatchPaymentProcessing()) {
      console.log('[支付自动化] 批量支付正在处理中，开始监听确认按钮');
      observeForConfirmButton();
    } else {
      console.log('[支付自动化] 批量支付未在处理中，跳过确认按钮监听');
    }
    return;
  }

  // 支付宝密码页面
  if (url.includes('mclient.alipay.com/h5pay/pwdValidate')) {
    console.log('[支付自动化] 检测到支付宝密码输入页面');
    if (isBatchPaymentProcessing()) {
      console.log('[支付自动化] 批量支付正在处理中，开始监听密码输入框');
      observeForPasswordInput();
    } else {
      console.log('[支付自动化] 批量支付未在处理中，跳过密码输入监听');
    }
    return;
  }

  // 支付宝 cashierActivity 页面 - 检查是否有支付成功标识
  if (url.includes('mclient.alipay.com/h5pay/cashierActivity') || url.includes('mclient.alipay.com/h5pay/cashierActivity/index.html')) {
    console.log('[支付自动化] 检测到支付宝 cashierActivity 页面，开始检查是否存在支付成功标识');
    console.log('[支付自动化] cashierActivity 页面URL:', url);

    // 创建一个函数来检查支付成功标识并处理
    var checkForSuccessIndicator = function checkForSuccessIndicator() {
      // 检查是否存在 cashierActivity__msg 标签且内容为"支付成功"
      var cashierActivityMsg = document.querySelector('div.cashierActivity__msg');
      if (cashierActivityMsg) {
        console.log('[支付自动化] 找到 cashierActivity__msg 元素，内容为:', cashierActivityMsg.textContent);
        if (cashierActivityMsg.textContent === '支付成功') {
          console.log('[支付自动化] 检测到 div.cashierActivity__msg 标签内容为"支付成功"，认为支付已完成');
          // 直接认为支付成功，关闭页面并进行下一个订单
          handlePaymentSuccess();
          return true;
        }
      } else {
        console.log('[支付自动化] 未找到 cashierActivity__msg 元素');
      }

      // 检查是否存在"完成"按钮
      var completeButtons = Array.from(document.querySelectorAll('button, .btn, [role="button"], div[onclick]'));
      console.log('[支付自动化] 找到按钮元素数量:', completeButtons.length);
      for (var _i2 = 0, _completeButtons = completeButtons; _i2 < _completeButtons.length; _i2++) {
        var btn = _completeButtons[_i2];
        var btnText = btn.textContent || '';
        console.log('[支付自动化] 按钮文本:', btnText);
        if (btnText.includes('完成')) {
          console.log('[支付自动化] 检测到页面中存在"完成"按钮，认为支付已完成');
          // 直接认为支付成功，关闭页面并进行下一个订单
          handlePaymentSuccess();
          return true;
        }
      }
      return false;
    };

    // 先立即检查一次
    if (!checkForSuccessIndicator()) {
      console.log('[支付自动化] 未检测到支付成功标识，开始监听页面变化');
      // 监听DOM变化，等待支付成功标识出现
      var observer = new MutationObserver(function () {
        if (checkForSuccessIndicator()) {
          observer.disconnect();
        }
      });
      observer.observe(document.body, {
        childList: true,
        subtree: true
      });

      // 同时监听页面重定向，以防支付流程继续到其他页面
      console.log('[支付自动化] 开始监听 cashierActivity 页面可能的重定向');
      waitForPageRedirect();
    }
    return;
  }

  // 检查是否需要自动支付(仅针对拼多多页面)
  if (shouldAutoPayment()) {
    console.log('[支付自动化] 检测到自动支付参数，开始自动支付流程');
    // 延迟执行，确保页面完全加载 - 增加延迟时间
    setTimeout(autoPaymentProcess, 4000); // 从2秒增加到4秒
    return;
  }

  // 对于未知页面类型，也启动申请退款按钮的持续监听
  console.log('[支付自动化] 未匹配到已知页面类型，当前URL:', url);
  observeForRefundButton();
}

// 增强的支付按钮查找函数
function findPayButton() {
  console.log('[支付自动化] 开始查找支付按钮');

  // 主要选择器 - 优先查找红色激活状态的支付按钮
  var primaryButton = document.querySelector('div[data-active="red"]');
  if (primaryButton && primaryButton.textContent.includes('去支付')) {
    console.log('[支付自动化] 找到主要支付按钮:', primaryButton.textContent);
    return primaryButton;
  }

  // 扩展的支付按钮选择器
  var payButtonSelectors = ['div[data-active="red"]',
  // 红色激活按钮
  'div[data-active="true"]',
  // 激活状态按钮
  'button[class*="pay"]',
  // 包含pay的按钮
  'div[class*="pay"]',
  // 包含pay的div
  'a[class*="pay"]',
  // 包含pay的链接
  'span[class*="pay"]',
  // 包含pay的span
  '.pay-button',
  // 支付按钮类
  '.btn-pay',
  // 支付按钮类
  '.payment-btn',
  // 支付按钮类
  '.submit-btn',
  // 提交按钮类
  '[data-testid*="pay"]',
  // 测试ID包含pay
  '[data-role="pay"]',
  // 支付角色
  '[data-action="pay"]',
  // 支付动作
  'button',
  // 所有按钮
  'div[role="button"]',
  // 按钮角色的div
  'span[role="button"]',
  // 按钮角色的span
  'a[role="button"]',
  // 按钮角色的链接
  '.btn',
  // 通用按钮类
  '.button',
  // 通用按钮类
  '[onclick*="pay"]',
  // 点击事件包含pay
  '[onclick*="submit"]' // 点击事件包含submit
  ];

  // 支付按钮可能的文本内容
  var payButtonTexts = ['去支付', '立即支付', '支付', '确认支付', '提交订单', '立即购买', '确认购买', '去付款', '付款', '结算', 'Pay', 'Submit', 'Checkout', 'Buy Now'];
  for (var _i3 = 0, _payButtonSelectors = payButtonSelectors; _i3 < _payButtonSelectors.length; _i3++) {
    var selector = _payButtonSelectors[_i3];
    var elements = document.querySelectorAll(selector);
    console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u4F7F\u7528\u9009\u62E9\u5668 ".concat(selector, " \u627E\u5230 ").concat(elements.length, " \u4E2A\u5143\u7D20"));
    var _iterator6 = _createForOfIteratorHelper(elements),
      _step6;
    try {
      var _loop = function _loop() {
          var element = _step6.value;
          var text = (element.textContent || element.innerText || '').trim();
          var isVisible = element.offsetWidth > 0 && element.offsetHeight > 0 && window.getComputedStyle(element).display !== 'none' && window.getComputedStyle(element).visibility !== 'hidden';
          console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u68C0\u67E5\u5143\u7D20: \"".concat(text, "\", \u53EF\u89C1: ").concat(isVisible, ", \u6807\u7B7E: ").concat(element.tagName, ", \u7C7B\u540D: ").concat(element.className));
          if (isVisible && text) {
            // 检查是否包含支付相关文本
            var hasPayText = payButtonTexts.some(function (payText) {
              return text.includes(payText);
            });
            if (hasPayText) {
              // 排除一些不相关的按钮
              if (text.includes('申请退款') || text.includes('退款') || text.includes('售后') || text.includes('取消') || text.includes('关闭') || text.includes('返回')) {
                console.log('[支付自动化] 跳过不相关按钮:', text);
                return 0; // continue
              }
              console.log('[支付自动化] 找到支付按钮:', text, element);
              return {
                v: element
              };
            }
          }
        },
        _ret;
      for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
        _ret = _loop();
        if (_ret === 0) continue;
        if (_ret) return _ret.v;
      }
    } catch (err) {
      _iterator6.e(err);
    } finally {
      _iterator6.f();
    }
  }

  // 如果还是没找到，尝试更宽泛的搜索
  console.log('[支付自动化] 进行更宽泛的搜索...');
  var allClickableElements = document.querySelectorAll('*');
  var _iterator7 = _createForOfIteratorHelper(allClickableElements),
    _step7;
  try {
    for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
      var element = _step7.value;
      var text = (element.textContent || element.innerText || '').trim();
      var isVisible = element.offsetWidth > 0 && element.offsetHeight > 0;
      if (isVisible && text && (text === '去支付' || text === '立即支付' || text === '支付')) {
        console.log('[支付自动化] 通过宽泛搜索找到支付按钮:', text, element);
        return element;
      }
    }
  } catch (err) {
    _iterator7.e(err);
  } finally {
    _iterator7.f();
  }
  console.log('[支付自动化] 未找到任何支付按钮');
  return null;
}

// 监听支付按钮出现
function observeForPayButton() {
  console.log('[支付自动化] 开始监听支付按钮出现');
  console.log('[支付自动化] 当前页面URL:', window.location.href);
  console.log('[支付自动化] 页面标题:', document.title);

  // 打印页面上所有可能的按钮元素用于调试
  var allButtons = document.querySelectorAll('button, div[role="button"], span[role="button"], a[role="button"], .btn, .button, div[data-active], div[class*="pay"]');
  console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u9875\u9762\u4E0A\u5171\u627E\u5230 ".concat(allButtons.length, " \u4E2A\u6309\u94AE\u5143\u7D20:"));
  allButtons.forEach(function (btn, index) {
    var text = (btn.textContent || btn.innerText || '').trim();
    var isVisible = btn.offsetWidth > 0 && btn.offsetHeight > 0;
    var dataActive = btn.getAttribute('data-active');
    console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u6309\u94AE".concat(index + 1, ": \"").concat(text, "\", \u53EF\u89C1: ").concat(isVisible, ", \u6807\u7B7E: ").concat(btn.tagName, ", \u7C7B\u540D: ").concat(btn.className, ", data-active: ").concat(dataActive));
  });
  var observer = new MutationObserver(function (mutations) {
    console.log('[支付自动化] 页面发生变化，重新查找支付按钮');

    // 检查已支付订单标识
    var paidOrderIndicator = checkForRefundButton();
    if (paidOrderIndicator) {
      console.log('[支付自动化] 检测到已支付订单标识，直接进入下一个订单');
      observer.disconnect();
      handleRefundDetected();
      return;
    }

    // 增强支付按钮检测逻辑
    var payButton = findPayButton();
    if (payButton) {
      console.log('[支付自动化] 支付按钮已出现，准备点击:', payButton);
      observer.disconnect();

      // 延迟一下再点击，确保按钮完全加载
      setTimeout(function () {
        // 检查是否应该自动点击支付按钮
        var shouldAutoClick = isBatchPaymentProcessing() || shouldAutoPayment();
        if (shouldAutoClick) {
          var currentUrl = window.location.href;

          // 根据当前页面URL判断应该执行哪种点击操作
          if (currentUrl.includes('mclient.alipay.com/h5pay/cashierPreConfirm')) {
            console.log('[支付自动化] 当前在支付宝确认页面，直接点击确认付款按钮');
            var confirmResult = clickConfirmPaymentButton();
            console.log('[支付自动化] 确认付款按钮点击结果:', confirmResult);
          } else {
            console.log('[支付自动化] 检测到自动支付条件，先选择支付宝支付后点击支付按钮');
            // 先选择支付宝支付
            var alipaySelected = selectAlipayPayment();
            if (alipaySelected) {
              console.log('[支付自动化] 支付宝支付方式已选择，等待500ms后点击支付按钮');
              setTimeout(function () {
                var clickResult = clickPayButton();
                console.log('[支付自动化] 支付按钮点击结果:', clickResult);
              }, 500);
            } else {
              console.log('[支付自动化] 未能选择支付宝支付方式，直接点击支付按钮');
              var clickResult = clickPayButton();
              console.log('[支付自动化] 支付按钮点击结果:', clickResult);
            }
          }
        } else {
          console.log('[支付自动化] 未检测到自动支付条件，跳过自动点击支付按钮');
        }
      }, 1000);
    }
  });
  observer.observe(document.body, {
    childList: true,
    subtree: true
  });

  // 也立即检查一次，防止按钮已经存在
  setTimeout(function () {
    console.log('[支付自动化] 立即检查支付按钮是否已存在');

    // 先检查已支付订单标识
    var paidOrderIndicator = checkForRefundButton();
    if (paidOrderIndicator) {
      console.log('[支付自动化] 发现已存在的已支付订单标识，直接进入下一个订单');
      observer.disconnect();
      handleRefundDetected();
      return;
    }
    var existingButton = findPayButton();
    if (existingButton) {
      console.log('[支付自动化] 发现已存在的支付按钮，准备点击:', existingButton);
      observer.disconnect();
      // 检查是否应该自动点击支付按钮
      var shouldAutoClick = isBatchPaymentProcessing() || shouldAutoPayment();
      if (shouldAutoClick) {
        var currentUrl = window.location.href;

        // 根据当前页面URL判断应该执行哪种点击操作
        if (currentUrl.includes('mclient.alipay.com/h5pay/cashierPreConfirm')) {
          console.log('[支付自动化] 当前在支付宝确认页面，直接点击确认付款按钮');
          var confirmResult = clickConfirmPaymentButton();
          console.log('[支付自动化] 确认付款按钮点击结果:', confirmResult);
        } else {
          console.log('[支付自动化] 检测到自动支付条件，先选择支付宝支付后点击支付按钮');
          // 先选择支付宝支付
          var alipaySelected = selectAlipayPayment();
          if (alipaySelected) {
            console.log('[支付自动化] 支付宝支付方式已选择，等待500ms后点击支付按钮');
            setTimeout(function () {
              var clickResult = clickPayButton();
              console.log('[支付自动化] 支付按钮点击结果:', clickResult);
            }, 500);
          } else {
            console.log('[支付自动化] 未能选择支付宝支付方式，直接点击支付按钮');
            var clickResult = clickPayButton();
            console.log('[支付自动化] 支付按钮点击结果:', clickResult);
          }
        }
      } else {
        console.log('[支付自动化] 未检测到自动支付条件，跳过自动点击支付按钮');
      }
    } else {
      console.log('[支付自动化] 未找到支付按钮，继续监听...');
    }
  }, 2000);

  // 增加超时机制，如果10秒内没有找到支付按钮，尝试强制查找
  setTimeout(function () {
    if (!observer) return;
    console.log('[支付自动化] 支付按钮监听超时，尝试强制查找');
    var payButton = findPayButton();
    if (payButton) {
      console.log('[支付自动化] 超时后找到支付按钮，准备点击:', payButton);
      observer.disconnect();
      // 只有在批量支付正在处理中才自动点击支付按钮
      if (isBatchPaymentProcessing()) {
        var currentUrl = window.location.href;

        // 根据当前页面URL判断应该执行哪种点击操作
        if (currentUrl.includes('mclient.alipay.com/h5pay/cashierPreConfirm')) {
          console.log('[支付自动化] 当前在支付宝确认页面，直接点击确认付款按钮');
          var confirmResult = clickConfirmPaymentButton();
          console.log('[支付自动化] 超时后确认付款按钮点击结果:', confirmResult);
        } else {
          console.log('[支付自动化] 批量支付正在处理中，先选择支付宝支付后超时点击支付按钮');
          // 先选择支付宝支付
          var alipaySelected = selectAlipayPayment();
          if (alipaySelected) {
            console.log('[支付自动化] 支付宝支付方式已选择，等待500ms后点击支付按钮');
            setTimeout(function () {
              var clickResult = clickPayButton();
              console.log('[支付自动化] 超时后支付按钮点击结果:', clickResult);
            }, 500);
          } else {
            console.log('[支付自动化] 未能选择支付宝支付方式，直接点击支付按钮');
            var clickResult = clickPayButton();
            console.log('[支付自动化] 超时后支付按钮点击结果:', clickResult);
          }
        }
      } else {
        console.log('[支付自动化] 批量支付未在处理中，跳过超时后自动点击支付按钮');
      }
    } else {
      console.warn('[支付自动化] 超时后仍未找到支付按钮，可能页面异常');
      // 打印页面HTML片段用于调试
      console.log('[支付自动化] 页面HTML片段:', document.body.innerHTML.substring(0, 1000));
      observer.disconnect();
    }
  }, 10000);
}

// 监听确认按钮出现
function observeForConfirmButton() {
  console.log('[支付自动化] 开始监听确认支付按钮出现');
  console.log('[支付自动化] 当前页面URL:', window.location.href);
  console.log('[支付自动化] 页面标题:', document.title);

  // 打印页面上所有可能的按钮元素用于调试
  var allButtons = document.querySelectorAll('button, div[role="button"], span[role="button"], a[role="button"], .btn, .button');
  console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u9875\u9762\u4E0A\u5171\u627E\u5230 ".concat(allButtons.length, " \u4E2A\u6309\u94AE\u5143\u7D20:"));
  allButtons.forEach(function (btn, index) {
    var text = (btn.textContent || btn.innerText || '').trim();
    var isVisible = btn.offsetWidth > 0 && btn.offsetHeight > 0;
    var dataActive = btn.getAttribute('data-active');
    console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u6309\u94AE".concat(index + 1, ": \"").concat(text, "\", \u53EF\u89C1: ").concat(isVisible, ", \u6807\u7B7E: ").concat(btn.tagName, ", \u7C7B\u540D: ").concat(btn.className, ", data-active: ").concat(dataActive));
  });
  var tryClick = function tryClick() {
    // 首先尝试原来的XPath方式（作为备用）
    var xpath = '/html/body/div[2]/div[3]/div[2]/button';
    var xpathNode = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
    if (xpathNode) {
      console.log('[支付自动化] 通过XPath找到确认支付按钮');
      var shouldAutoClick = isBatchPaymentProcessing() || shouldAutoPayment();
      if (shouldAutoClick) {
        setTimeout(function () {
          sendMessageToParent({
            type: 'PAYMENT_STEP_UPDATE',
            step: 'confirm_payment'
          });
          xpathNode.click();
          console.log('[支付自动化] 确认按钮已点击 (XPath)');
          setTimeout(function () {
            return waitForPageRedirect();
          }, 200);
        }, 200);
      }
      return true;
    }

    // 使用通用选择器查找确认按钮
    var buttonSelectors = ['button.adm-button.adm-button-primary.adm-button-block.adm-button-large',
    // 从日志中看到的类名
    'button.cashierPreConfirm__btn',
    // 从日志中看到的类名
    'button[class*="cashierPreConfirm"]', 'button[class*="adm-button-primary"]', 'button', 'div[role="button"]'];
    var confirmTexts = ['确认付款', '确认支付', '立即付款', '立即支付', '付款', '支付'];
    for (var _i4 = 0, _buttonSelectors = buttonSelectors; _i4 < _buttonSelectors.length; _i4++) {
      var selector = _buttonSelectors[_i4];
      var buttons = document.querySelectorAll(selector);
      var _iterator8 = _createForOfIteratorHelper(buttons),
        _step8;
      try {
        var _loop2 = function _loop2() {
            var button = _step8.value;
            var text = (button.textContent || button.innerText || '').trim();
            var isVisible = button.offsetWidth > 0 && button.offsetHeight > 0 && window.getComputedStyle(button).display !== 'none' && window.getComputedStyle(button).visibility !== 'hidden';
            if (isVisible && confirmTexts.some(function (confirmText) {
              return text.includes(confirmText);
            })) {
              console.log('[支付自动化] 通过通用选择器找到确认支付按钮:', text);
              var _shouldAutoClick = isBatchPaymentProcessing() || shouldAutoPayment();
              if (_shouldAutoClick) {
                setTimeout(function () {
                  sendMessageToParent({
                    type: 'PAYMENT_STEP_UPDATE',
                    step: 'confirm_payment'
                  });
                  button.click();
                  console.log('[支付自动化] 确认按钮已点击 (通用选择器):', text);
                  setTimeout(function () {
                    return waitForPageRedirect();
                  }, 200);
                }, 200);
              } else {
                console.log('[支付自动化] 未检测到自动支付条件，跳过自动点击确认按钮');
              }
              return {
                v: true
              };
            }
          },
          _ret2;
        for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
          _ret2 = _loop2();
          if (_ret2) return _ret2.v;
        }
      } catch (err) {
        _iterator8.e(err);
      } finally {
        _iterator8.f();
      }
    }
    return false;
  };

  // 先立即尝试一次
  if (tryClick()) return;

  // 监听DOM变化，直到按钮出现
  var observer = new MutationObserver(function () {
    if (tryClick()) {
      observer.disconnect();
    }
  });
  observer.observe(document.body, {
    childList: true,
    subtree: true
  });

  // 添加超时机制，10秒后强制检查一次
  setTimeout(function () {
    console.log('[支付自动化] 确认按钮监听超时，尝试最后一次查找');
    if (tryClick()) {
      observer.disconnect();
    } else {
      console.warn('[支付自动化] 超时后仍未找到确认按钮');
      observer.disconnect();
    }
  }, 10000);
}

// 监听密码输入框出现
function observeForPasswordInput() {
  console.log('[支付自动化] 开始监听密码输入框');

  // 检查密码输入框是否存在（支持6位和8位密码输入框）
  var checkPasswordInput = function checkPasswordInput() {
    // 检查6位密码输入框
    var passwordContainer = document.querySelector('div.my-passcode-input.length-6');
    // 检查8位密码输入框（企业支付）
    var enterpriseInput = document.querySelector('input.adm-input-element[type="password"][placeholder*="支付密码"]');
    return passwordContainer || enterpriseInput;
  };
  var handlePasswordInput = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
      var shouldAutoInput;
      return _regeneratorRuntime().wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            console.log('[支付自动化] 密码输入框已出现');

            // 点亮"输入支付密码"步骤
            sendMessageToParent({
              type: 'PAYMENT_STEP_UPDATE',
              step: 'input_password'
            });

            // 通知后台脚本密码输入框已准备好
            chrome.runtime.sendMessage({
              action: 'passwordInputReady'
            });

            // 检查是否应该自动输入密码
            shouldAutoInput = isBatchPaymentProcessing() || shouldAutoPayment();
            if (shouldAutoInput) {
              // 更快地自动输入密码
              setTimeout(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
                var password, inputSuccess;
                return _regeneratorRuntime().wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      console.log('[支付自动化] 批量支付正在处理中，准备自动输入密码');
                      _context.next = 3;
                      return getPaymentPassword();
                    case 3:
                      password = _context.sent;
                      if (password) {
                        console.log('[支付自动化] 获取到支付密码，开始输入');
                        inputSuccess = enhancedInputPassword(password);
                        if (inputSuccess) {
                          console.log('[支付自动化] 密码输入成功，开始监听页面重定向到支付成功页面');
                          waitForPageRedirect();
                        }
                      } else {
                        chrome.runtime.sendMessage({
                          action: 'getPaymentPassword'
                        }, function (response) {
                          if (response && response.password) {
                            console.log('[支付自动化] 通过消息获取到支付密码，开始输入');
                            var _inputSuccess = enhancedInputPassword(response.password);
                            if (_inputSuccess) {
                              console.log('[支付自动化] 密码输入成功，开始监听页面重定向到支付成功页面');
                              waitForPageRedirect();
                            }
                          } else {
                            console.log('[支付自动化] 未获取到支付密码');
                          }
                        });
                      }
                    case 5:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              })), 200); // 将1s延迟缩短为200ms
            } else {
              console.log('[支付自动化] 未检测到自动支付条件，跳过自动输入密码');
            }
          case 5:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function handlePasswordInput() {
      return _ref.apply(this, arguments);
    };
  }();
  var observer = new MutationObserver(function (mutations) {
    if (checkPasswordInput()) {
      observer.disconnect();
      handlePasswordInput();
    }
  });

  // 首先检查密码输入框是否已经存在
  if (checkPasswordInput()) {
    console.log('[支付自动化] 密码输入框已存在，直接处理');
    handlePasswordInput();
    return;
  }
  observer.observe(document.body, {
    childList: true,
    subtree: true
  });
}

// 处理支付成功页面
function handlePaymentSuccess() {
  // 避免重复上报
  if (window.__PDD_PAYMENT_SUCCESS_REPORTED__) {
    console.log('[支付自动化] 支付成功已上报，跳过重复处理');
    return;
  }
  window.__PDD_PAYMENT_SUCCESS_REPORTED__ = true;
  console.log('[支付自动化] 检测到支付成功页面');

  // 通知父窗口支付步骤更新与结果，便于更快推进下一个订单
  try {
    // 步骤更新
    sendMessageToParent({
      type: 'PAYMENT_STEP_UPDATE',
      step: 'payment_success'
    });
    // 成功结果
    var orderSn = getOrderSn();
    sendMessageToParent({
      type: 'PAYMENT_RESULT',
      orderSn: orderSn,
      success: true,
      message: '支付成功（成功页检测）'
    });
  } catch (e) {
    console.warn('[支付自动化] 向父窗口发送支付成功消息失败:', e);
  }

  // 通知后台脚本支付成功，请求进入下一个订单（兼容旧链路）
  chrome.runtime.sendMessage({
    action: 'paymentSuccess',
    nextOrder: true
  });

  // 判断是否应该关闭窗口
  var isBatchMode = isBatchPaymentMode();
  var isProcessing = isBatchPaymentProcessing();
  console.log('[支付自动化] 支付成功页面 - 批量支付模式:', isBatchMode, '正在处理中:', isProcessing);
  var shouldClose = false;
  var reason = '';
  if (shouldKeepWindowOpen()) {
    // 调试模式，保持窗口打开
    reason = '调试模式，保持窗口打开';
  } else if (!isBatchMode) {
    // 非批量支付模式（手动点击），不关闭窗口
    reason = '非批量支付模式，保持窗口打开避免突兀';
  } else if (isBatchMode && isProcessing) {
    // 批量支付模式且正在处理中，关闭窗口
    shouldClose = true;
    reason = '批量支付模式且正在处理中，关闭窗口';
  } else {
    // 批量支付模式但未在处理中，关闭窗口
    shouldClose = true;
    reason = '批量支付模式但未在处理中，关闭窗口';
  }
  console.log('[支付自动化] 支付成功页面窗口关闭决策:', {
    shouldClose: shouldClose,
    reason: reason
  });
  if (shouldClose) {
    _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
      var maxWait, poll, start;
      return _regeneratorRuntime().wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            // 等待父页面ACK，最多2.5秒；期间轮询100ms
            maxWait = 2500;
            poll = 100;
            start = Date.now();
          case 3:
            if (!(!window.__PDD_PAYMENT_ACKED__ && Date.now() - start < maxWait)) {
              _context3.next = 8;
              break;
            }
            _context3.next = 6;
            return sleep(poll);
          case 6:
            _context3.next = 3;
            break;
          case 8:
            console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] ".concat(window.__PDD_PAYMENT_ACKED__ ? '已收到父窗口ACK，' : 'ACK等待超时，', "\u51C6\u5907\u5173\u95ED\u6210\u529F\u9875\u7A97\u53E3: ").concat(reason));
            setTimeout(function () {
              try {
                window.close();
              } catch (e) {
                console.warn('[支付自动化] 关闭支付成功页面失败:', e);
              }
            }, 200);
          case 10:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }))();
  } else {
    console.log('[支付自动化] 支付成功页面保持窗口打开:', reason);
    // 只在调试模式下显示提示信息
    if (shouldKeepWindowOpen()) {
      showProgress('支付成功！窗口保持打开以便调试');
    }
  }
}

// 检查支付是否成功
function checkPaymentSuccess() {
  var url = window.location.href;
  console.log('[支付自动化] 检查支付是否成功，当前URL:', url);

  // 检查页面中是否存在 cashierActivity__msg 标签且内容为"支付成功"
  var cashierActivityMsg = document.querySelector('div.cashierActivity__msg');
  if (cashierActivityMsg) {
    console.log('[支付自动化] 找到 cashierActivity__msg 元素，内容为:', cashierActivityMsg.textContent);
    if (cashierActivityMsg.textContent === '支付成功') {
      console.log('[支付自动化] 检测到 div.cashierActivity__msg 标签内容为"支付成功"，认为支付已完成');
      return true;
    }
  } else {
    console.log('[支付自动化] 未找到 cashierActivity__msg 元素');
  }

  // 检查页面中是否存在"完成"按钮
  var completeButtons = Array.from(document.querySelectorAll('button, .btn, [role="button"], div[onclick]'));
  console.log('[支付自动化] 找到按钮元素数量:', completeButtons.length);
  for (var _i5 = 0, _completeButtons2 = completeButtons; _i5 < _completeButtons2.length; _i5++) {
    var btn = _completeButtons2[_i5];
    var btnText = btn.textContent || '';
    console.log('[支付自动化] 按钮文本:', btnText);
    if (btnText.includes('完成')) {
      console.log('[支付自动化] 检测到页面中存在"完成"按钮，认为支付已完成');
      return true;
    }
  }

  // 检查页面内容是否包含成功信息
  var successTexts = ['支付成功', '付款成功', '交易成功', '支付完成'];
  var bodyText = document.body ? document.body.textContent : '';
  for (var _i6 = 0, _successTexts = successTexts; _i6 < _successTexts.length; _i6++) {
    var text = _successTexts[_i6];
    if (bodyText.includes(text)) {
      console.log('[支付自动化] 检测到页面内容包含成功信息：' + text);
      return true;
    }
  }
  console.log('[支付自动化] 未检测到任何支付成功标识');
  return false;
}

// 等待页面重定向到支付确认页面
function waitForPageRedirect() {
  console.log('[支付自动化] 开始监听页面重定向');
  var redirectTimer;
  var timeoutTimer;

  // 检查URL变化的函数
  function checkUrlChange() {
    var currentUrl = window.location.href;
    var previousUrl = window.__PDD_PREVIOUS_URL__ || '';
    console.log('[支付自动化] 当前URL:', currentUrl);
    console.log('[支付自动化] 上一个URL:', previousUrl);

    // 记录当前URL用于下次比较
    window.__PDD_PREVIOUS_URL__ = currentUrl;

    // 检查是否为支付成功页面
    if (checkPaymentSuccess()) {
      console.log('[支付自动化] 在URL监听中检测到支付成功页面');
      clearInterval(redirectTimer);
      clearTimeout(timeoutTimer);
      handlePaymentSuccess();
      return;
    }
    if (currentUrl.includes('mclient.alipay.com/h5pay/cashierPreConfirm')) {
      console.log('[支付自动化] 检测到页面已重定向到支付确认页面');
      // 点亮"确认支付"步骤
      sendMessageToParent({
        type: 'PAYMENT_STEP_UPDATE',
        step: 'confirm_payment'
      });
      clearInterval(redirectTimer);
      clearTimeout(timeoutTimer);
      setTimeout(function () {
        console.log('[支付自动化] 开始监听确认按钮');
        observeForConfirmButton();
      }, 200);
    } else if (currentUrl.includes('mclient.alipay.com/h5pay/pwdValidate')) {
      console.log('[支付自动化] 检测到页面已重定向到密码输入页面');

      // 点亮"输入支付密码"步骤
      sendMessageToParent({
        type: 'PAYMENT_STEP_UPDATE',
        step: 'input_password'
      });
      clearInterval(redirectTimer);
      clearTimeout(timeoutTimer);
      setTimeout(function () {
        console.log('[支付自动化] 开始监听密码输入框');
        observeForPasswordInput();
      }, 200);
    } else if (currentUrl.includes('mclient.alipay.com/h5pay/cashierActivity')) {
      console.log('[支付自动化] 检测到页面已重定向到cashierActivity页面');
      // 检查是否有支付成功标识
      if (checkPaymentSuccess()) {
        console.log('[支付自动化] cashierActivity页面检测到支付成功标识');
        clearInterval(redirectTimer);
        clearTimeout(timeoutTimer);
        handlePaymentSuccess();
      } else {
        console.log('[支付自动化] cashierActivity页面未检测到支付成功标识，继续监听页面变化');
        // 继续监听，不清除定时器
      }
    }
  }

  // 立即执行一次URL检查
  checkUrlChange();

  // 每500毫秒检查一次URL变化
  redirectTimer = setInterval(checkUrlChange, 500);

  // 设置超时保护，10秒后如果还没有检测到页面变化，则停止监听
  timeoutTimer = setTimeout(function () {
    console.log('[支付自动化] 页面重定向监听超时，停止监听');
    clearInterval(redirectTimer);

    // 再次检查当前页面状态
    var finalCheck = checkPaymentSuccess();
    console.log('[支付自动化] 超时前最后检查支付状态:', finalCheck ? '成功' : '未成功');
    if (finalCheck) {
      handlePaymentSuccess();
    }
  }, 10000);
}

// 增强的密码输入功能
// 检查申请退款按钮
function checkForRefundButton() {
  console.log('[支付自动化] 检查已支付订单标识');
  var pathname = window.location.pathname;
  var isOrderDetailPage = pathname.includes('order.html') || pathname.includes('transac_combine_order.html');
  var pageTitle = document.title || '';

  // 检查页面标题是否表明订单已支付
  var paidOrderTitles = ['待发货', '已发货', '待收货', '已完成', '交易成功'];
  if (paidOrderTitles.some(function (title) {
    return pageTitle.includes(title);
  })) {
    console.log('[支付自动化] 页面标题显示订单已支付:', pageTitle);
    return {
      text: "\u9875\u9762\u6807\u9898: ".concat(pageTitle),
      element: null
    };
  }

  // 仅基于更严格的按钮文本进行判断，避免误判
  var strictRefundTexts = ['申请退款', '申请售后', '退款成功', '退款完成'];

  // 仅在按钮/可点击元素中查找，且要求可见
  var candidateSelectors = 'button, a[role="button"], div[role="button"], .btn, .button';
  var elements = document.querySelectorAll(candidateSelectors);
  var _iterator9 = _createForOfIteratorHelper(elements),
    _step9;
  try {
    var _loop3 = function _loop3() {
        var el = _step9.value;
        var text = (el.textContent || el.innerText || '').trim();
        var isVisible = el.offsetWidth > 0 && el.offsetHeight > 0 && window.getComputedStyle(el).display !== 'none' && window.getComputedStyle(el).visibility !== 'hidden';
        if (!isVisible || !text) return 0; // continue

        // 订单详情页：出现以下任意文字即判定跳过，不受支付按钮是否存在影响
        if (isOrderDetailPage) {
          if (strictRefundTexts.some(function (t) {
            return text.includes(t);
          })) {
            console.log('[支付自动化] 订单详情页检测到退款/售后相关文字，直接跳过当前订单');
            return {
              v: {
                text: text,
                element: el
              }
            };
          }
        } else {
          // 其它页面：仍然严格检测这些文字
          if (strictRefundTexts.some(function (t) {
            return text.includes(t);
          })) {
            console.log('[支付自动化] 检测到已支付/可退款相关按钮:', text);
            return {
              v: {
                text: text,
                element: el
              }
            };
          }
        }
      },
      _ret3;
    for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
      _ret3 = _loop3();
      if (_ret3 === 0) continue;
      if (_ret3) return _ret3.v;
    }
  } catch (err) {
    _iterator9.e(err);
  } finally {
    _iterator9.f();
  }
  return null;
}

// 持续监听申请退款按钮
function observeForRefundButton() {
  console.log('[支付自动化] 开始持续监听申请退款按钮');
  var observer = new MutationObserver(function (mutations) {
    var refundButton = checkForRefundButton();
    if (refundButton) {
      console.log('[支付自动化] 监听到申请退款按钮出现，直接进入下一个订单');
      observer.disconnect();
      handleRefundDetected();
    }
  });
  observer.observe(document.body, {
    childList: true,
    subtree: true
  });

  // 10秒后停止监听（避免无限监听）
  setTimeout(function () {
    observer.disconnect();
    console.log('[支付自动化] 申请退款按钮监听超时，停止监听');
  }, 10000);
}

// 处理检测到已支付订单标识的情况
function handleRefundDetected() {
  console.log('[支付自动化] 处理已支付订单标识检测');
  var isBatchMode = isBatchPaymentMode();
  var isProcessing = isBatchPaymentProcessing();
  console.log('[支付自动化] 批量支付模式:', isBatchMode, '正在处理中:', isProcessing);

  // 发送消息给后台脚本，通知进入下一个订单
  chrome.runtime.sendMessage({
    action: 'paymentSuccess',
    nextOrder: true,
    reason: 'paid_order_detected',
    message: '检测到已支付订单标识，跳过当前订单'
  }, function (response) {
    console.log('[支付自动化] 已支付订单检测消息发送结果:', response);
  });

  // 判断是否应该关闭窗口
  var shouldClose = false;
  var reason = '';
  if (shouldKeepWindowOpen()) {
    // 调试模式，保持窗口打开
    reason = '调试模式，保持窗口打开';
  } else if (!isBatchMode) {
    // 非批量支付模式（手动点击），不关闭窗口
    reason = '非批量支付模式，保持窗口打开避免突兀';
  } else if (isBatchMode && isProcessing) {
    // 批量支付模式且正在处理中，关闭窗口
    shouldClose = true;
    reason = '批量支付模式且正在处理中，关闭窗口';
  } else {
    // 批量支付模式但未在处理中，关闭窗口
    shouldClose = true;
    reason = '批量支付模式但未在处理中，关闭窗口';
  }
  console.log('[支付自动化] 窗口关闭决策:', {
    shouldClose: shouldClose,
    reason: reason
  });
  if (shouldClose) {
    setTimeout(function () {
      console.log('[支付自动化] 关闭当前窗口:', reason);
      window.close();
    }, 1000);
  } else {
    console.log('[支付自动化] 保持窗口打开:', reason);
    // 只在调试模式下显示提示信息
    if (shouldKeepWindowOpen()) {
      showProgress('检测到已支付订单，跳过当前订单。窗口保持打开以便调试');
    }
  }
}
function enhancedInputPassword(password) {
  console.log('[支付自动化] 开始增强密码输入流程');

  // 方法1: 查找6位密码输入框容器（最常见的场景，优先尝试）
  var passwordContainer = document.querySelector('div.my-passcode-input.length-6');
  if (passwordContainer) {
    console.log('[支付自动化] 找到6位密码输入框容器');

    // 查找隐藏的原生输入框
    var nativeInput = passwordContainer.querySelector('input.my-passcode-input-native-input');
    if (nativeInput) {
      console.log('[支付自动化] 找到原生输入框，直接设置密码值');

      // 先点击容器激活
      passwordContainer.click();
      passwordContainer.focus();

      // 设置输入框值
      nativeInput.focus();
      nativeInput.value = password;

      // 触发输入事件
      nativeInput.dispatchEvent(new Event('input', {
        bubbles: true
      }));
      nativeInput.dispatchEvent(new Event('change', {
        bubbles: true
      }));
      nativeInput.dispatchEvent(new Event('keyup', {
        bubbles: true
      }));
      console.log('[支付自动化] 密码输入完成，值为:', nativeInput.value);

      // 6位密码输入后开始监听密码错误 (50ms延迟)
      setTimeout(function () {
        monitorPasswordError();
      }, 50);
      return true;
    }

    // 备用方案：逐个设置每个cell
    var cells = passwordContainer.querySelectorAll('.my-passcode-input-cell');
    if (cells.length === 6 && password.length === 6) {
      console.log('[支付自动化] 使用备用方案，逐个设置密码cell');

      // 先点击容器激活
      passwordContainer.click();
      passwordContainer.focus();

      // 逐个输入每位密码
      var _loop4 = function _loop4(i) {
        setTimeout(function () {
          var cell = cells[i];
          cell.textContent = password[i];
          cell.classList.remove('dot');

          // 模拟键盘输入事件
          var keyEvent = new KeyboardEvent('keydown', {
            key: password[i],
            code: "Digit".concat(password[i]),
            bubbles: true
          });
          passwordContainer.dispatchEvent(keyEvent);
          console.log("[\u652F\u4ED8\u81EA\u52A8\u5316] \u8BBE\u7F6E\u7B2C".concat(i + 1, "\u4E2A\u5BC6\u7801\u4F4D: ").concat(password[i]));

          // 最后一位密码输入后开始监听密码错误 (50ms延迟)
          if (i === 5) {
            setTimeout(function () {
              monitorPasswordError();
            }, 50);
          }
        }, i * 100);
      };
      for (var i = 0; i < 6; i++) {
        _loop4(i);
      }
      return true;
    }
    console.log('[支付自动化] 未找到合适的输入方式');
    return false;
  }

  // 方法2: 通过XPath查找新版密码输入框（备用方案）
  var xpathInput = '//*[@id="app"]/div[2]/div[2]/div/div/input';
  var xpathResult = document.evaluate(xpathInput, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
  var directInput = xpathResult.singleNodeValue;
  if (directInput) {
    console.log('[支付自动化] 通过XPath找到密码输入框，直接设置密码值');

    // 先点击输入框激活
    directInput.click();
    directInput.focus();

    // 设置输入框值
    directInput.value = password;

    // 触发输入事件
    directInput.dispatchEvent(new Event('input', {
      bubbles: true
    }));
    directInput.dispatchEvent(new Event('change', {
      bubbles: true
    }));
    directInput.dispatchEvent(new Event('keyup', {
      bubbles: true
    }));
    console.log('[支付自动化] 密码输入完成（XPath方式），值为:', directInput.value);

    // 查找并点击"下一步"按钮
    setTimeout(function () {
      clickNextStepButton();
    }, 300);
    return true;
  }

  // 方法3: 通过class选择器查找8位密码输入框（企业支付场景）
  var enterpriseInput = document.querySelector('input.adm-input-element[type="password"][placeholder*="支付密码"]');
  if (enterpriseInput) {
    console.log('[支付自动化] 找到企业支付8位密码输入框');

    // 先点击输入框激活
    enterpriseInput.click();
    enterpriseInput.focus();

    // 设置输入框值
    enterpriseInput.value = password;

    // 触发输入事件
    enterpriseInput.dispatchEvent(new Event('input', {
      bubbles: true
    }));
    enterpriseInput.dispatchEvent(new Event('change', {
      bubbles: true
    }));
    enterpriseInput.dispatchEvent(new Event('keyup', {
      bubbles: true
    }));
    console.log('[支付自动化] 密码输入完成（企业支付方式），值为:', enterpriseInput.value);

    // 查找并点击"下一步"按钮
    setTimeout(function () {
      clickNextStepButton();
    }, 300);
    return true;
  }
  console.log('[支付自动化] 未找到任何密码输入框');
  return false;
}

// 点击"下一步"按钮（用于8位密码输入后）
function clickNextStepButton() {
  console.log('[支付自动化] 开始查找"下一步"按钮');

  // 方法1: 通过XPath查找
  var xpathButton = '//*[@id="app"]/div[2]/div[2]/button';
  var xpathResult = document.evaluate(xpathButton, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
  var nextButton = xpathResult.singleNodeValue;
  if (nextButton) {
    var buttonText = (nextButton.textContent || nextButton.innerText || '').trim();
    console.log('[支付自动化] 通过XPath找到按钮，文本:', buttonText);
    if (buttonText === '下一步') {
      nextButton.click();
      console.log('[支付自动化] "下一步"按钮已点击');

      // 点击后开始监听密码错误 (50ms延迟)
      setTimeout(function () {
        monitorPasswordError();
      }, 50);
      return true;
    }
  }

  // 方法2: 通过class选择器查找
  var nextButtonByClass = document.querySelector('button.pwdValidate__btn[data-aspm-click]');
  if (nextButtonByClass) {
    var _buttonText = (nextButtonByClass.textContent || nextButtonByClass.innerText || '').trim();
    console.log('[支付自动化] 通过class找到按钮，文本:', _buttonText);
    if (_buttonText === '下一步') {
      nextButtonByClass.click();
      console.log('[支付自动化] "下一步"按钮已点击（class方式）');

      // 点击后开始监听密码错误 (50ms延迟)
      setTimeout(function () {
        monitorPasswordError();
      }, 50);
      return true;
    }
  }

  // 方法3: 通用搜索包含"下一步"的按钮
  var allButtons = document.querySelectorAll('button');
  var _iterator10 = _createForOfIteratorHelper(allButtons),
    _step10;
  try {
    for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
      var button = _step10.value;
      var _buttonText2 = (button.textContent || button.innerText || '').trim();
      if (_buttonText2 === '下一步') {
        var isVisible = button.offsetWidth > 0 && button.offsetHeight > 0 && window.getComputedStyle(button).display !== 'none' && window.getComputedStyle(button).visibility !== 'hidden';
        if (isVisible) {
          console.log('[支付自动化] 通过通用搜索找到"下一步"按钮');
          button.click();
          console.log('[支付自动化] "下一步"按钮已点击（通用方式）');

          // 点击后立即监听密码错误 (几乎无延迟)
          setTimeout(function () {
            monitorPasswordError();
          }, 10);
          return true;
        }
      }
    }
  } catch (err) {
    _iterator10.e(err);
  } finally {
    _iterator10.f();
  }
  console.log('[支付自动化] 未找到"下一步"按钮');
  return false;
}

// 监听密码错误提示
function monitorPasswordError() {
  console.log('[支付自动化] 开始监听密码错误提示');
  var checkCount = 0;
  var maxChecks = 300; // 检查6秒 (300次 * 20ms)

  var checkInterval = setInterval(function () {
    checkCount++;

    // 检查是否已跳转到成功页面
    var currentUrl = window.location.href;
    if (currentUrl.includes('cashierActivity') || currentUrl.includes('success') || currentUrl.includes('result')) {
      console.log('[支付自动化] 已跳转到支付成功页面，停止密码错误检测');
      clearInterval(checkInterval);
      return;
    }

    // 方法1: 优先使用XPath快速检测错误对话框 (最快)
    var xpathDialog = '/html/body/div[5]/div/div[2]/div/div/div[1]/div/div';
    var xpathResult = document.evaluate(xpathDialog, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
    var errorDialogByXPath = xpathResult.singleNodeValue;
    if (errorDialogByXPath) {
      var computedStyle = window.getComputedStyle(errorDialogByXPath);
      var isVisible = errorDialogByXPath.offsetWidth > 0 && errorDialogByXPath.offsetHeight > 0 && computedStyle.display !== 'none' && computedStyle.visibility !== 'hidden' && parseFloat(computedStyle.opacity) > 0;
      if (isVisible) {
        // 获取对话框文字内容
        var text = (errorDialogByXPath.textContent || errorDialogByXPath.innerText || '').trim();
        var errorMessage = text || '支付密码错误';
        console.error('❌ [支付自动化] 检测到密码错误对话框(XPath):', errorMessage);
        clearInterval(checkInterval);

        // 通知父窗口密码错误
        sendMessageToParent({
          type: 'PAYMENT_RESULT',
          success: false,
          error: '支付密码有误',
          errorDetail: errorMessage,
          passwordError: true
        });

        // 通知后台脚本
        chrome.runtime.sendMessage({
          action: 'paymentSuccess',
          nextOrder: true,
          reason: 'password_error',
          message: '支付密码有误'
        });

        // 立即关闭窗口
        console.log('[支付自动化] 密码错误，立即关闭窗口');
        window.close();
        return;
      }
    }

    // 方法2: 检查密码锁定提示
    var lockedPasswordContent = document.querySelector('.adm-auto-center-content');
    if (lockedPasswordContent) {
      // 只检查最基本的可见性：display 和 visibility
      var _computedStyle = window.getComputedStyle(lockedPasswordContent);
      var isBasicallyVisible = _computedStyle.display !== 'none' && _computedStyle.visibility !== 'hidden';
      if (isBasicallyVisible) {
        var _text2 = (lockedPasswordContent.textContent || lockedPasswordContent.innerText || '').trim();

        // 检查是否为密码锁定或密码错误相关提示
        if (_text2.includes('支付密码已被锁定') || _text2.includes('请3小时后再试') || _text2.includes('支付密码不正确') || _text2.includes('你还可以输入')) {
          console.error('❌ [支付自动化] 检测到密码错误或锁定提示:', _text2);
          clearInterval(checkInterval);

          // 通知父窗口密码错误
          sendMessageToParent({
            type: 'PAYMENT_RESULT',
            success: false,
            error: '支付密码有误',
            errorDetail: _text2,
            passwordError: true
          });

          // 通知后台脚本
          chrome.runtime.sendMessage({
            action: 'paymentSuccess',
            nextOrder: true,
            reason: 'password_error',
            message: '支付密码有误'
          });

          // 立即关闭窗口
          console.log('[支付自动化] 密码错误或锁定，立即关闭窗口');
          window.close();
          return;
        }
      }
    }

    // 方法3: 检查特定的错误提示元素
    var errorContent = document.querySelector('.adm-dialog-content .adm-auto-center-content');
    if (errorContent) {
      // 只检查最基本的可见性：display 和 visibility
      var _computedStyle2 = window.getComputedStyle(errorContent);
      var _isBasicallyVisible = _computedStyle2.display !== 'none' && _computedStyle2.visibility !== 'hidden';
      if (_isBasicallyVisible) {
        var _text3 = (errorContent.textContent || errorContent.innerText || '').trim();
        if (_text3.includes('支付密码不正确') || _text3.includes('你还可以输入') || _text3.includes('密码已被锁定') || _text3.includes('密码错误')) {
          console.error('❌ [支付自动化] 支付密码错误:', _text3);
          clearInterval(checkInterval);

          // 通知父窗口密码错误
          sendMessageToParent({
            type: 'PAYMENT_RESULT',
            success: false,
            error: '支付密码有误',
            errorDetail: _text3,
            passwordError: true
          });

          // 通知后台脚本
          chrome.runtime.sendMessage({
            action: 'paymentSuccess',
            nextOrder: true,
            reason: 'password_error',
            message: '支付密码有误'
          });

          // 立即关闭窗口
          console.log('[支付自动化] 密码错误，立即关闭窗口');
          window.close();
          return;
        }
      }
    }
    if (checkCount >= maxChecks) {
      console.log('[支付自动化] 密码错误检测超时（6秒），假定密码正确');
      clearInterval(checkInterval);
    }
  }, 20); // 20ms检查一次，极速响应
}
/******/ })()
;