/******/ (() => { // webpackBootstrap
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// 商品收藏页面辅助功能：提取商品ID、规格ID、拼单链接等信息
// 页面链接：https://mobile.yangkeduo.com/likes.html
var LikesPageHelper = /*#__PURE__*/function () {
  function LikesPageHelper() {
    _classCallCheck(this, LikesPageHelper);
    this.debugMode = true;
    this.isDestroyed = false;
    this.extractButton = null;
    this.goodsDataMap = new Map(); // 存储商品数据
    this.init();
  }
  return _createClass(LikesPageHelper, [{
    key: "log",
    value: function log() {
      if (this.debugMode && !this.isDestroyed) {
        var _console;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        (_console = console).log.apply(_console, ['商品收藏助手：'].concat(args));
      }
    }
  }, {
    key: "error",
    value: function error() {
      var _console2;
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      (_console2 = console).error.apply(_console2, ['商品收藏助手：'].concat(args));
    }
  }, {
    key: "init",
    value: function init() {
      var _this = this;
      if (this.isDestroyed) return;
      this.log('初始化开始');
      this.log('当前URL:', window.location.href);

      // 等待页面加载完成
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function () {
          if (!_this.isDestroyed) {
            _this.setup();
          }
        });
      } else {
        this.setup();
      }
    }
  }, {
    key: "setup",
    value: function setup() {
      var _this2 = this;
      if (this.isDestroyed) return;

      // 检查是否在商品收藏页面
      if (!this.isLikesPage()) {
        this.log('不是商品收藏页面，退出');
        return;
      }
      this.log('确认是商品收藏页面，开始设置');

      // 等待rawData加载
      this.waitForRawData(function () {
        if (!_this2.isDestroyed) {
          _this2.log('rawData加载成功');
          _this2.createExtractButton();
          // 自动提取商品信息
          _this2.extractGoodsInfo();
        }
      });
    }
  }, {
    key: "isLikesPage",
    value: function isLikesPage() {
      var isYangkeduo = window.location.hostname.includes('mobile.yangkeduo.com') || window.location.hostname.includes('yangkeduo.com');
      var hasLikesPath = window.location.pathname.includes('/likes');
      return isYangkeduo && hasLikesPath;
    }
  }, {
    key: "waitForRawData",
    value: function waitForRawData(callback) {
      var _this3 = this;
      var maxAttempts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 50;
      if (this.isDestroyed) return;
      var attempts = 0;
      var checkRawData = function checkRawData() {
        if (_this3.isDestroyed) return false;
        attempts++;
        _this3.log("\u68C0\u67E5rawData\u7B2C".concat(attempts, "\u6B21"));

        // 检查是否有rawData和goodsSet
        if (window.rawData && window.rawData.baseStore && window.rawData.baseStore.goodsSet) {
          _this3.log('找到window.rawData.baseStore.goodsSet');
          callback();
          return true;
        }

        // 检查其他可能的数据源
        if (window.__INITIAL_STATE__) {
          _this3.log('找到__INITIAL_STATE__');
          window.rawData = window.__INITIAL_STATE__;
          if (window.rawData.baseStore && window.rawData.baseStore.goodsSet) {
            callback();
            return true;
          }
        }

        // 检查script标签中的 window.rawData= 格式数据
        var scripts = document.querySelectorAll('script:not([src])');
        var _iterator = _createForOfIteratorHelper(scripts),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var script = _step.value;
            var content = script.textContent || script.innerHTML;
            if (content.includes('window.rawData=')) {
              _this3.log('在script标签中找到window.rawData赋值');
              try {
                // 提取window.rawData=后面的JSON数据
                var match = content.match(/window\.rawData\s*=\s*(\{[^]*?\});?\s*(?:$|window\.)/);
                if (match) {
                  var _data$baseStore;
                  _this3.log('提取到rawData JSON字符串');
                  var jsonStr = match[1];
                  var data = JSON.parse(jsonStr);
                  if ((_data$baseStore = data.baseStore) !== null && _data$baseStore !== void 0 && _data$baseStore.goodsSet) {
                    window.rawData = data;
                    _this3.log('通过script标签成功解析rawData');
                    callback();
                    return true;
                  }
                }
              } catch (e) {
                _this3.log('解析script中的rawData失败:', e.message);
              }
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        if (attempts >= maxAttempts) {
          _this3.error('rawData未加载，已达到最大尝试次数');
          return false;
        }
        return false;
      };

      // 立即检查一次
      if (checkRawData()) {
        return;
      }

      // 设置定时检查
      var checkInterval = setInterval(function () {
        if (_this3.isDestroyed) {
          clearInterval(checkInterval);
          return;
        }
        if (checkRawData()) {
          clearInterval(checkInterval);
        }
      }, 500);

      // 监听页面变化
      var throttleTimer = null;
      var dataObserver = new MutationObserver(function () {
        if (_this3.isDestroyed) {
          dataObserver.disconnect();
          return;
        }
        if (throttleTimer) return;
        throttleTimer = setTimeout(function () {
          throttleTimer = null;
          if (checkRawData()) {
            clearInterval(checkInterval);
            dataObserver.disconnect();
          }
        }, 200);
      });
      if (document.body && !this.isDestroyed) {
        dataObserver.observe(document.body, {
          childList: true,
          subtree: false
        });
      }
    }
  }, {
    key: "createExtractButton",
    value: function createExtractButton() {
      var _this4 = this;
      if (this.isDestroyed || this.extractButton) return;
      this.log('创建提取规格信息按钮');

      // 创建按钮
      var button = document.createElement('button');
      button.textContent = '提取规格信息';
      button.style.cssText = "\n            position: fixed;\n            top: 50px;\n            left: 10px;\n            z-index: 10000;\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            color: white;\n            border: none;\n            padding: 12px 20px;\n            border-radius: 8px;\n            font-size: 14px;\n            font-weight: 600;\n            cursor: pointer;\n            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);\n            transition: all 0.3s ease;\n        ";

      // 添加悬停效果
      button.onmouseover = function () {
        button.style.transform = 'translateY(-2px)';
        button.style.boxShadow = '0 6px 20px rgba(102, 126, 234, 0.6)';
      };
      button.onmouseout = function () {
        button.style.transform = 'translateY(0)';
        button.style.boxShadow = '0 4px 15px rgba(102, 126, 234, 0.4)';
      };

      // 点击事件：刷新页面
      button.onclick = function () {
        _this4.log('刷新页面以更新规格信息');
        window.location.reload();
      };
      document.body.appendChild(button);
      this.extractButton = button;
      this.log('刷新按钮创建完成');
    }
  }, {
    key: "extractGoodsInfo",
    value: function extractGoodsInfo() {
      var _this5 = this;
      this.log('开始提取商品信息');

      // 重新加载rawData（用户可能进行了操作）
      if (!window.rawData || !window.rawData.baseStore || !window.rawData.baseStore.goodsSet) {
        this.error('rawData不存在或格式不正确');
        alert('数据加载失败，请刷新页面重试');
        return;
      }
      var goodsSet = window.rawData.baseStore.goodsSet;
      this.log('goodsSet数据:', goodsSet);

      // 查找商品列表容器
      var listWrapper = document.querySelector('.infinite-list-wrapper');
      if (!listWrapper) {
        this.error('未找到商品列表容器');
        return;
      }

      // 获取所有商品div
      var goodsDivs = listWrapper.querySelectorAll('.lsV8hrhO');
      this.log("\u627E\u5230".concat(goodsDivs.length, "\u4E2A\u5546\u54C1div"));

      // 遍历每个商品div
      goodsDivs.forEach(function (goodsDiv, index) {
        _this5.processGoodsDiv(goodsDiv, index, goodsSet);
      });
      this.log('商品信息提取完成');
    }
  }, {
    key: "processGoodsDiv",
    value: function processGoodsDiv(goodsDiv, index, goodsSet) {
      // 查找商品名称
      var goodsNameElement = goodsDiv.querySelector('.h7J5pYhu');
      if (!goodsNameElement) {
        this.log("\u7B2C".concat(index + 1, "\u4E2A\u5546\u54C1\u672A\u627E\u5230\u540D\u79F0\u5143\u7D20"));
        return;
      }
      var goodsName = goodsNameElement.textContent.trim();
      this.log("\u7B2C".concat(index + 1, "\u4E2A\u5546\u54C1\u540D\u79F0:"), goodsName);

      // 在goodsSet中查找匹配的商品
      var matchedGoods = null;
      var matchedGoodsId = null;
      for (var _i = 0, _Object$entries = Object.entries(goodsSet); _i < _Object$entries.length; _i++) {
        var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
          goodsId = _Object$entries$_i[0],
          goodsData = _Object$entries$_i[1];
        if (goodsData.goodsName === goodsName) {
          matchedGoods = goodsData;
          matchedGoodsId = goodsId;
          break;
        }
      }
      if (!matchedGoods) {
        this.log("\u7B2C".concat(index + 1, "\u4E2A\u5546\u54C1\u672A\u627E\u5230\u5339\u914D\u6570\u636E"));
        return;
      }
      this.log("\u7B2C".concat(index + 1, "\u4E2A\u5546\u54C1\u5339\u914D\u6210\u529F\uFF0C\u5546\u54C1ID:"), matchedGoodsId);

      // 检查是否已经添加过信息
      var existingInfo = goodsDiv.querySelector('.goods-spec-info');
      if (existingInfo) {
        existingInfo.remove();
      }

      // 创建商品信息显示区域
      var infoDiv = this.createGoodsInfoDiv(matchedGoodsId, matchedGoods);

      // 插入到商品div的底部
      goodsDiv.appendChild(infoDiv);
    }
  }, {
    key: "createGoodsInfoDiv",
    value: function createGoodsInfoDiv(goodsId, goodsData) {
      var infoDiv = document.createElement('div');
      infoDiv.className = 'goods-spec-info';
      infoDiv.style.cssText = "\n            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);\n            border: 1px solid #dee2e6;\n            border-radius: 8px;\n            padding: 12px;\n            margin: 10px 12px;\n            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;\n            box-shadow: 0 2px 8px rgba(0,0,0,0.05);\n        ";

      // 构建HTML内容
      var html = "\n            <div style=\"display: flex; flex-direction: column; gap: 8px;\">\n                <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 8px; background: rgba(255,255,255,0.7); border-radius: 4px;\">\n                    <div style=\"display: flex; align-items: center; gap: 8px;\">\n                        <span style=\"color: #666; font-size: 13px; font-weight: 500;\">\u5546\u54C1ID:</span>\n                        <span style=\"color: #e02e24; font-weight: 600; font-size: 14px; font-family: monospace;\">".concat(goodsId, "</span>\n                    </div>\n                    <button\n                        onclick=\"navigator.clipboard.writeText('").concat(goodsId, "').then(() => {\n                            const btn = this;\n                            const oldText = btn.textContent;\n                            btn.textContent = '\u2713\u5DF2\u590D\u5236';\n                            btn.style.background = '#4caf50';\n                            setTimeout(() => {\n                                btn.textContent = oldText;\n                                btn.style.background = '#007bff';\n                            }, 1000);\n                        })\"\n                        style=\"\n                            background: #007bff;\n                            color: white;\n                            border: none;\n                            padding: 4px 8px;\n                            border-radius: 4px;\n                            font-size: 11px;\n                            cursor: pointer;\n                            transition: all 0.2s ease;\n                        \"\n                        onmouseover=\"this.style.background='#0056b3'\"\n                        onmouseout=\"this.style.background='#007bff'\"\n                    >\u590D\u5236</button>\n                </div>\n        ");

      // 添加规格信息
      if (goodsData.mergePayList && goodsData.mergePayList.length > 0) {
        html += "<div style=\"padding: 8px; background: rgba(255,255,255,0.7); border-radius: 4px;\">\n                <div style=\"color: #666; font-size: 13px; font-weight: 500; margin-bottom: 8px;\">\u5546\u54C1\u89C4\u683C:</div>";
        goodsData.mergePayList.forEach(function (sku, skuIndex) {
          // 构建规格名称
          var specNames = sku.spec.map(function (s) {
            return s.value;
          }).join(' / ');

          // 构建拼单链接
          var groupPurchaseLink = "https://mobile.yangkeduo.com/order_checkout.html?sku_id=".concat(sku.skuId, "&group_id=").concat(goodsData.groupId, "&goods_id=").concat(goodsId, "&goods_number=1");
          html += "\n                    <div style=\"border-left: 3px solid #28a745; padding: 8px; margin-bottom: 8px; background: rgba(255,255,255,0.5); border-radius: 4px;\">\n                        <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 6px 8px; background: rgba(255,255,255,0.7); border-radius: 4px; border-left: 3px solid #28a745; margin-bottom: 6px;\">\n                            <div style=\"display: flex; align-items: center; gap: 8px;\">\n                                <span style=\"color: #666; font-size: 12px; font-weight: 500;\">\u5DF2\u9009\u89C4\u683C:</span>\n                                <span style=\"color: #28a745; font-size: 12px; font-weight: 500;\">".concat(specNames, "</span>\n                            </div>\n                            <button\n                                onclick=\"navigator.clipboard.writeText('").concat(specNames, "').then(() => {\n                                    const btn = this;\n                                    const oldText = btn.textContent;\n                                    btn.textContent = '\u2713\u5DF2\u590D\u5236';\n                                    btn.style.background = '#4caf50';\n                                    setTimeout(() => {\n                                        btn.textContent = oldText;\n                                        btn.style.background = '#007bff';\n                                    }, 1000);\n                                })\"\n                                style=\"\n                                    background: #007bff;\n                                    color: white;\n                                    border: none;\n                                    padding: 4px 8px;\n                                    border-radius: 4px;\n                                    font-size: 11px;\n                                    cursor: pointer;\n                                    transition: all 0.2s ease;\n                                \"\n                                onmouseover=\"this.style.background='#0056b3'\"\n                                onmouseout=\"this.style.background='#007bff'\"\n                            >\u590D\u5236</button>\n                        </div>\n                        <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 8px; background: rgba(255,255,255,0.7); border-radius: 4px; margin-bottom: 4px;\">\n                            <div style=\"display: flex; align-items: center; gap: 8px;\">\n                                <span style=\"color: #666; font-size: 13px; font-weight: 500;\">\u89C4\u683CID:</span>\n                                <span style=\"color: #4caf50; font-weight: 600; font-size: 14px; font-family: monospace;\">").concat(sku.skuId, "</span>\n                            </div>\n                            <button\n                                onclick=\"navigator.clipboard.writeText('").concat(sku.skuId, "').then(() => {\n                                    const btn = this;\n                                    const oldText = btn.textContent;\n                                    btn.textContent = '\u2713\u5DF2\u590D\u5236';\n                                    btn.style.background = '#4caf50';\n                                    setTimeout(() => {\n                                        btn.textContent = oldText;\n                                        btn.style.background = '#007bff';\n                                    }, 1000);\n                                })\"\n                                style=\"\n                                    background: #007bff;\n                                    color: white;\n                                    border: none;\n                                    padding: 4px 8px;\n                                    border-radius: 4px;\n                                    font-size: 11px;\n                                    cursor: pointer;\n                                    transition: all 0.2s ease;\n                                \"\n                                onmouseover=\"this.style.background='#0056b3'\"\n                                onmouseout=\"this.style.background='#007bff'\"\n                            >\u590D\u5236</button>\n                        </div>\n                        <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 6px 8px; background: rgba(255,255,255,0.7); border-radius: 4px; border-left: 3px solid #ff6b35; margin-bottom: 4px;\">\n                            <div style=\"display: flex; align-items: center; gap: 8px;\">\n                                <span style=\"color: #666; font-size: 12px; font-weight: 500;\">\u89C4\u683C\u4FE1\u606F:</span>\n                                <span style=\"color: #ff6b35; font-size: 12px; font-weight: 500;\">\u5355\u4EF7:").concat((sku.skuPrice / 100).toFixed(2), " / \u5E93\u5B58:").concat(sku.skuQuantity, "</span>\n                            </div>\n                            <button\n                                onclick=\"navigator.clipboard.writeText('\u5355\u4EF7:").concat((sku.skuPrice / 100).toFixed(2), " / \u5E93\u5B58:").concat(sku.skuQuantity, "').then(() => {\n                                    const btn = this;\n                                    const oldText = btn.textContent;\n                                    btn.textContent = '\u2713\u5DF2\u590D\u5236';\n                                    btn.style.background = '#4caf50';\n                                    setTimeout(() => {\n                                        btn.textContent = oldText;\n                                        btn.style.background = '#007bff';\n                                    }, 1000);\n                                })\"\n                                style=\"\n                                    background: #007bff;\n                                    color: white;\n                                    border: none;\n                                    padding: 4px 8px;\n                                    border-radius: 4px;\n                                    font-size: 11px;\n                                    cursor: pointer;\n                                    transition: all 0.2s ease;\n                                \"\n                                onmouseover=\"this.style.background='#0056b3'\"\n                                onmouseout=\"this.style.background='#007bff'\"\n                            >\u590D\u5236</button>\n                        </div>\n                        <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 8px; background: rgba(255,255,255,0.7); border-radius: 4px; border-left: 3px solid #9c27b0;\">\n                            <div style=\"display: flex; align-items: center; gap: 8px; flex: 1;\">\n                                <span style=\"color: #666; font-size: 12px; font-weight: 500;\">\u62FC\u5355\u94FE\u63A5:</span>\n                                <span style=\"color: #9c27b0; font-size: 11px; font-weight: 500; word-break: break-all; flex: 1;\">").concat(groupPurchaseLink, "</span>\n                            </div>\n                            <button\n                                onclick=\"navigator.clipboard.writeText('").concat(groupPurchaseLink, "').then(() => {\n                                    const btn = this;\n                                    const oldText = btn.textContent;\n                                    btn.textContent = '\u2713\u5DF2\u590D\u5236';\n                                    btn.style.background = '#4caf50';\n                                    setTimeout(() => {\n                                        btn.textContent = oldText;\n                                        btn.style.background = '#007bff';\n                                    }, 1000);\n                                })\"\n                                style=\"\n                                    background: #007bff;\n                                    color: white;\n                                    border: none;\n                                    padding: 4px 8px;\n                                    border-radius: 4px;\n                                    font-size: 11px;\n                                    cursor: pointer;\n                                    transition: all 0.2s ease;\n                                    margin-left: 8px;\n                                    flex-shrink: 0;\n                                \"\n                                onmouseover=\"this.style.background='#0056b3'\"\n                                onmouseout=\"this.style.background='#007bff'\"\n                            >\u590D\u5236</button>\n                        </div>\n                    </div>\n                ");
        });
        html += "</div>";
      }

      // 添加底部信息
      html += "\n                <div style=\"text-align: center; padding: 4px 8px; font-size: 11px; color: #666; margin-top: 5px;\">\n                    \u4EE5\u4E0A\u4FE1\u606F\u7531<span style=\"color: #1890ff; font-weight: 500;\">\u591A\u591A\u5F00</span>\u63D0\u4F9B\u6280\u672F\u652F\u6301\n                </div>\n            </div>\n        ";
      infoDiv.innerHTML = html;
      return infoDiv;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.isDestroyed = true;
      this.log('销毁助手');

      // 清理按钮
      if (this.extractButton) {
        this.extractButton.remove();
        this.extractButton = null;
      }

      // 清理所有添加的商品信息
      var allInfoDivs = document.querySelectorAll('.goods-spec-info');
      allInfoDivs.forEach(function (div) {
        return div.remove();
      });
    }
  }]);
}(); // 页面加载时初始化
var likesPageHelper = null;
console.log('商品收藏助手脚本加载');
console.log('当前页面URL:', window.location.href);

// 检查是否在商品收藏页面
var isLikesPage = (window.location.hostname.includes('mobile.yangkeduo.com') || window.location.hostname.includes('yangkeduo.com')) && window.location.pathname.includes('/likes');
console.log('是否为商品收藏页面:', isLikesPage);
if (isLikesPage) {
  console.log('确认是商品收藏页面，准备初始化助手');

  // 立即尝试初始化
  var tryInit = function tryInit() {
    console.log('尝试初始化商品收藏助手');
    if (!likesPageHelper) {
      likesPageHelper = new LikesPageHelper();
    }
  };

  // 多种时机尝试初始化
  if (document.readyState === 'complete') {
    console.log('页面已完全加载，立即初始化');
    tryInit();
  } else if (document.readyState === 'interactive') {
    console.log('DOM已加载，延迟500ms初始化');
    setTimeout(tryInit, 500);
  } else {
    console.log('页面还在加载，等待DOMContentLoaded事件');
    document.addEventListener('DOMContentLoaded', function () {
      console.log('DOMContentLoaded事件触发，延迟100ms初始化');
      setTimeout(tryInit, 100);
    });
  }

  // 保险起见，再设置一个延迟初始化
  setTimeout(function () {
    if (!likesPageHelper) {
      console.log('兜底初始化触发');
      tryInit();
    } else {
      console.log('助手已存在，跳过兜底初始化');
    }
  }, 2000);
}

// 页面卸载时清理
window.addEventListener('beforeunload', function () {
  console.log('页面即将卸载，清理助手');
  if (likesPageHelper) {
    likesPageHelper.destroy();
  }
});

// 导出供其他脚本使用
window.LikesPageHelper = LikesPageHelper;
console.log('商品收藏助手脚本初始化完成');
/******/ })()
;