/******/ (() => { // webpackBootstrap
/******/ 	"use strict";

;// ./src/utils/constants.js
// 创建一个常量对象并使用 Object.freeze
// https://pdd-order-plugin-backend-production.up.railway.app
// https://duoduokai.behring.tech/
var Constants = Object.freeze({
  API_BASE_URL: 'https://pdd-order-plugin-backend-production.up.railway.app',
  API_BASE_URL_STANDBY: 'https://duoduokai.behring.tech',
  FREE_USER_MAX_ACCOUNTS: 2,
  FREE_USER_MAX_ORDERS: 10,
  MAX_REQUESTS_PER_HOUR: 1200,
  ONE_HOUR_IN_MS: 3600000,
  // 1小时的毫秒数
  ENABLE_LOGISTICS_DETAILS: false,
  // 物流明细字段开关，默认关闭

  // convertOrderLink 配置
  USE_CUSTOM_CONVERT_PARAMS: false,
  // 是否使用自定义转换参数，默认关闭
  CONVERT_ORDER_LINK_PARAMS: {
    client_id: '7d1bdd2429c14c428ac1ddcaed6d2868',
    client_secret: '71d5c73e453489c058956191ff74e1ebf32c48b8',
    pid: '9484223_285702705'
  }
});

// 导出常量
var API_BASE_URL = Constants.API_BASE_URL,
  API_BASE_URL_STANDBY = Constants.API_BASE_URL_STANDBY,
  constants_FREE_USER_MAX_ACCOUNTS = Constants.FREE_USER_MAX_ACCOUNTS,
  FREE_USER_MAX_ORDERS = Constants.FREE_USER_MAX_ORDERS,
  MAX_REQUESTS_PER_HOUR = Constants.MAX_REQUESTS_PER_HOUR,
  ONE_HOUR_IN_MS = Constants.ONE_HOUR_IN_MS,
  ENABLE_LOGISTICS_DETAILS = Constants.ENABLE_LOGISTICS_DETAILS,
  USE_CUSTOM_CONVERT_PARAMS = Constants.USE_CUSTOM_CONVERT_PARAMS,
  CONVERT_ORDER_LINK_PARAMS = Constants.CONVERT_ORDER_LINK_PARAMS;

// 统一的 User-Agent 设置

var USER_AGENT = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1';
;// ./src/utils/variables.js
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
// Global variables that can be modified
var MAX_ACCOUNT_ORDER_NUMBER = 10;

// 导入常量


// 缓存当前用户信息
var cachedUser = null;
var lastCacheTime = 0;
var CACHE_TIMEOUT = 30000; // 30秒缓存有效期

// Functions to update the variables
// 如果value为-1，则表示不限订单数
function setMaxAccountOrderNumber(value) {
  if (value === -1) {
    MAX_ACCOUNT_ORDER_NUMBER = 100000;
  } else {
    MAX_ACCOUNT_ORDER_NUMBER = value;
  }
}

// Functions to get the variables
function getMaxAccountOrderNumber() {
  return MAX_ACCOUNT_ORDER_NUMBER;
}

// 检查用户是否有批量功能权限（只基于package_name字段）
function checkBatchPermission(packageName) {
  var allowedPlans = ['TRIAL', 'PRO', 'ULTIMATE'];
  console.log('checkBatchPermission - package_name:', packageName);
  console.log('checkBatchPermission - allowedPlans:', allowedPlans);

  // 检查package_name字段
  if (!packageName) {
    console.log('checkBatchPermission - package_name为空或未定义');
    return false;
  }

  // 转换为大写进行比较，处理可能的大小写不一致
  var normalizedPlan = packageName.toString().toUpperCase();
  var hasPermission = allowedPlans.includes(normalizedPlan);
  console.log('checkBatchPermission - normalizedPlan:', normalizedPlan);
  console.log('checkBatchPermission - 结果:', hasPermission);
  return hasPermission;
}

// 清除用户缓存，强制重新获取用户信息
function clearUserCache() {
  console.log('clearUserCache - 清除用户缓存');
  cachedUser = null;
  lastCacheTime = 0;
}

// 异步获取当前用户信息
function getCurrentUser() {
  return _getCurrentUser.apply(this, arguments);
}

// 设置当前用户信息
function _getCurrentUser() {
  _getCurrentUser = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
    var now, storage, user, requiredFields, missingFields, fullUser;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          now = Date.now(); // 使用较短的缓存时间，确保权限检查更新能够及时生效
          if (!(cachedUser && now - lastCacheTime < 5000)) {
            _context.next = 5;
            break;
          }
          // 5秒缓存
          console.log('getCurrentUser - 返回缓存的用户信息');
          return _context.abrupt("return", cachedUser);
        case 5:
          console.log('getCurrentUser - 尝试获取用户信息');

          // 获取用户信息 - 同时检查两个可能的键以保持兼容性
          _context.next = 8;
          return chrome.storage.local.get(['user', 'currentUser']);
        case 8:
          storage = _context.sent;
          console.log('getCurrentUser - 存储内容:', storage ? '获取成功' : '获取失败');
          user = storage.user || storage.currentUser;
          console.log('getCurrentUser - 用户信息:', user ? {
            username: user.username,
            payment_model: user.payment_model,
            access_token: user.access_token ? '存在' : '不存在'
          } : 'null');
          if (user) {
            _context.next = 16;
            break;
          }
          console.log('getCurrentUser - 未找到用户信息');
          cachedUser = null; // 清除缓存
          return _context.abrupt("return", null);
        case 16:
          // 检查用户是否有批量功能权限（只基于package_name字段）
          console.log('准备检查权限 - package_name:', user.package_name);
          console.log('用户完整信息:', user);
          user.hasBatchPermission = checkBatchPermission(user.package_name);
          console.log('权限检查完成 - hasBatchPermission:', user.hasBatchPermission);

          // 检查access_token是否存在
          if (!user.access_token) {
            console.warn('getCurrentUser - 用户缺少access_token，可能需要重新登录');
          }

          // 检查必要的字段
          requiredFields = ['username', 'id', 'payment_model'];
          missingFields = requiredFields.filter(function (field) {
            return !user[field];
          });
          if (missingFields.length > 0) {
            console.warn("getCurrentUser - \u7528\u6237\u4FE1\u606F\u7F3A\u5C11\u5FC5\u8981\u5B57\u6BB5: ".concat(missingFields.join(', ')));
          }

          // 确保返回的用户对象包含所有必要的字段
          fullUser = _objectSpread(_objectSpread({}, user), {}, {
            max_orders: user.max_orders || MAX_ACCOUNT_ORDER_NUMBER,
            max_pdd_accounts: user.max_pdd_accounts || constants_FREE_USER_MAX_ACCOUNTS,
            pdd_accounts: user.pdd_accounts || [],
            coins: user.coins || 0,
            hasBatchPermission: user.hasBatchPermission // 确保权限字段被正确传递
          });
          console.log('fullUser 对象创建完成:', {
            username: fullUser.username,
            package_name: fullUser.package_name,
            hasBatchPermission: fullUser.hasBatchPermission
          });

          // 更新缓存
          cachedUser = fullUser;
          lastCacheTime = now;
          return _context.abrupt("return", fullUser);
        case 31:
          _context.prev = 31;
          _context.t0 = _context["catch"](0);
          console.error('Error getting current user:', _context.t0);
          return _context.abrupt("return", cachedUser || null);
        case 35:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 31]]);
  }));
  return _getCurrentUser.apply(this, arguments);
}
function setCurrentUser(_x) {
  return _setCurrentUser.apply(this, arguments);
}
function _setCurrentUser() {
  _setCurrentUser = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(user) {
    var userData, verification, _verification;
    return _regeneratorRuntime().wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          if (!user) {
            _context2.next = 17;
            break;
          }
          // 确保保存的用户信息包含所有必要的字段
          userData = _objectSpread(_objectSpread({}, user), {}, {
            max_orders: user.max_orders || MAX_ACCOUNT_ORDER_NUMBER,
            max_pdd_accounts: user.max_pdd_accounts || FREE_USER_MAX_ACCOUNTS,
            pdd_accounts: user.pdd_accounts || []
          });
          console.log('setCurrentUser - 保存用户数据:', {
            username: userData.username,
            hasAccessToken: !!userData.access_token,
            maxOrders: userData.max_orders
          });

          // 同时保存到两个键以确保兼容性
          _context2.next = 6;
          return chrome.storage.local.set({
            user: userData,
            currentUser: userData
          });
        case 6:
          _context2.next = 8;
          return chrome.storage.local.get(['user', 'currentUser']);
        case 8:
          verification = _context2.sent;
          if (!(!verification.user || !verification.currentUser)) {
            _context2.next = 11;
            break;
          }
          throw new Error('用户数据保存失败：验证时未找到数据');
        case 11:
          console.log('setCurrentUser - 用户数据保存成功并已验证');

          // 更新最大订单数
          setMaxAccountOrderNumber(userData.max_orders);

          // 更新缓存
          cachedUser = userData;
          lastCacheTime = Date.now();
          _context2.next = 27;
          break;
        case 17:
          console.log('setCurrentUser - 清除用户数据');
          _context2.next = 20;
          return chrome.storage.local.remove(['user', 'currentUser']);
        case 20:
          _context2.next = 22;
          return chrome.storage.local.get(['user', 'currentUser']);
        case 22:
          _verification = _context2.sent;
          if (_verification.user || _verification.currentUser) {
            console.warn('setCurrentUser - 用户数据清除可能不完整');
          }

          // 重置最大订单数到默认值
          setMaxAccountOrderNumber(10);

          // 清除缓存
          cachedUser = null;
          lastCacheTime = 0;
        case 27:
          _context2.next = 33;
          break;
        case 29:
          _context2.prev = 29;
          _context2.t0 = _context2["catch"](0);
          console.error('Error setting current user:', _context2.t0);
          throw _context2.t0;
        case 33:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 29]]);
  }));
  return _setCurrentUser.apply(this, arguments);
}
;// ./src/content/goodsDetailHelper.js
function goodsDetailHelper_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ goodsDetailHelper_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == goodsDetailHelper_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(goodsDetailHelper_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function goodsDetailHelper_asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function goodsDetailHelper_asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { goodsDetailHelper_asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { goodsDetailHelper_asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function goodsDetailHelper_typeof(o) { "@babel/helpers - typeof"; return goodsDetailHelper_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, goodsDetailHelper_typeof(o); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, goodsDetailHelper_toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function goodsDetailHelper_toPropertyKey(t) { var i = goodsDetailHelper_toPrimitive(t, "string"); return "symbol" == goodsDetailHelper_typeof(i) ? i : i + ""; }
function goodsDetailHelper_toPrimitive(t, r) { if ("object" != goodsDetailHelper_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != goodsDetailHelper_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// 商品详情页面辅助功能：显示商品ID和规格ID
// 基于实际PDD页面结构，监听"去拼单"按钮点击和规格选择变化

// 导入用户相关工具函数


var GoodsDetailHelper = /*#__PURE__*/function () {
  function GoodsDetailHelper() {
    _classCallCheck(this, GoodsDetailHelper);
    this.goodsId = null;
    this.skuId = null;
    this.selectedSpecs = [];
    this.infoBar = null;
    this.observer = null;
    this.skusData = [];
    this.debugMode = true;
    this.isDestroyed = false;
    this.checkInterval = null;
    this.dataObserver = null;
    this.clickHandler = null;
    this.specObserver = null;
    // 添加价格和库存信息
    this.skuInfo = {
      quantity: null,
      groupPrice: null,
      normalPrice: null
    };
    // 添加groupId信息
    this.groupId = null;
    this.init();
  }
  return _createClass(GoodsDetailHelper, [{
    key: "log",
    value: function log() {
      if (this.debugMode && !this.isDestroyed) {
        var _console;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        (_console = console).log.apply(_console, ['商品详情助手：'].concat(args));
      }
    }
  }, {
    key: "error",
    value: function error() {
      var _console2;
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      (_console2 = console).error.apply(_console2, ['商品详情助手：'].concat(args));
    }
  }, {
    key: "init",
    value: function init() {
      var _this = this;
      if (this.isDestroyed) return;
      this.log('初始化开始');
      this.log('当前URL:', window.location.href);
      this.log('页面加载状态:', document.readyState);

      // 等待页面加载完成
      if (document.readyState === 'loading') {
        this.log('等待DOM加载完成...');
        document.addEventListener('DOMContentLoaded', function () {
          if (!_this.isDestroyed) {
            _this.log('DOM加载完成，开始设置');
            _this.setup();
          }
        });
      } else {
        this.log('DOM已加载完成，直接设置');
        this.setup();
      }
    }
  }, {
    key: "setup",
    value: function setup() {
      var _this2 = this;
      if (this.isDestroyed) return;
      this.log('开始设置功能');

      // 检查是否在商品详情页面
      if (!this.isGoodsDetailPage()) {
        this.log('不是商品详情页面，退出');
        return;
      }
      this.log('确认是商品详情页面，开始等待数据');

      // 先创建信息条，显示等待状态
      this.createInfoBar();
      this.updateDisplay('等待数据加载...');

      // 多种方式检查rawData
      this.waitForRawData(function () {
        if (!_this2.isDestroyed) {
          _this2.log('rawData加载成功，开始提取数据');
          _this2.extractGoodsData();
          _this2.setupPurchaseButtonMonitor();
          _this2.setupSpecificationMonitor();
          _this2.updateDisplay();
        }
      });
    }
  }, {
    key: "isGoodsDetailPage",
    value: function isGoodsDetailPage() {
      var isYangkeduo = window.location.hostname.includes('mobile.yangkeduo.com') || window.location.hostname.includes('yangkeduo.com');
      var hasGoodsPath = window.location.pathname.includes('/goods') || window.location.search.includes('goods_id');
      this.log('页面检查:', {
        hostname: window.location.hostname,
        pathname: window.location.pathname,
        search: window.location.search,
        isYangkeduo: isYangkeduo,
        hasGoodsPath: hasGoodsPath,
        result: isYangkeduo && hasGoodsPath
      });
      return isYangkeduo && hasGoodsPath;
    }
  }, {
    key: "waitForRawData",
    value: function waitForRawData(callback) {
      var _this3 = this;
      var maxAttempts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 50;
      if (this.isDestroyed) return;
      var attempts = 0;
      var checkRawData = function checkRawData() {
        if (_this3.isDestroyed) return false;
        attempts++;
        _this3.log("\u68C0\u67E5rawData\u7B2C".concat(attempts, "\u6B21"));

        // 检查是否有rawData
        if (window.rawData && window.rawData.store && window.rawData.store.initDataObj) {
          _this3.log('找到window.rawData');
          callback();
          return true;
        }

        // 检查其他可能的数据源
        if (window.__INITIAL_STATE__) {
          _this3.log('找到__INITIAL_STATE__');
          window.rawData = window.__INITIAL_STATE__;
          callback();
          return true;
        }

        // 检查script标签中的 window.rawData= 格式数据
        var scripts = document.querySelectorAll('script:not([src])');
        var _iterator = _createForOfIteratorHelper(scripts),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var script = _step.value;
            var content = script.textContent || script.innerHTML;
            if (content.includes('window.rawData=')) {
              _this3.log('在script标签中找到window.rawData赋值');
              try {
                // 提取window.rawData=后面的JSON数据
                var match = content.match(/window\.rawData\s*=\s*(\{[^]*?\});?\s*(?:$|window\.)/);
                if (match) {
                  var _data$store;
                  _this3.log('提取到rawData JSON字符串');
                  var jsonStr = match[1];
                  var data = JSON.parse(jsonStr);
                  if ((_data$store = data.store) !== null && _data$store !== void 0 && _data$store.initDataObj) {
                    window.rawData = data;
                    _this3.log('通过script标签成功解析rawData');
                    callback();
                    return true;
                  }
                }
              } catch (e) {
                _this3.log('解析script中的rawData失败:', e.message);
              }
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        if (!_this3.isDestroyed) {
          _this3.updateDisplay("\u7B49\u5F85\u6570\u636E\u52A0\u8F7D... (".concat(attempts, "/").concat(maxAttempts, ")"));
        }
        if (attempts >= maxAttempts) {
          _this3.error('rawData未加载，已达到最大尝试次数');
          if (!_this3.isDestroyed) {
            _this3.updateDisplay('数据加载失败');
          }
          return false;
        }
        return false;
      };

      // 立即检查一次
      if (checkRawData()) {
        return;
      }

      // 设置定时检查
      this.checkInterval = setInterval(function () {
        if (_this3.isDestroyed) {
          clearInterval(_this3.checkInterval);
          return;
        }
        if (checkRawData()) {
          clearInterval(_this3.checkInterval);
          _this3.checkInterval = null;
        }
      }, 500);

      // 监听页面变化
      var throttleTimer = null;
      this.dataObserver = new MutationObserver(function () {
        if (_this3.isDestroyed) {
          _this3.dataObserver.disconnect();
          return;
        }
        if (throttleTimer) return;
        throttleTimer = setTimeout(function () {
          throttleTimer = null;
          if (checkRawData()) {
            clearInterval(_this3.checkInterval);
            _this3.checkInterval = null;
            _this3.dataObserver.disconnect();
            _this3.dataObserver = null;
          }
        }, 200);
      });
      if (document.body && !this.isDestroyed) {
        this.dataObserver.observe(document.body, {
          childList: true,
          subtree: false
        });
      }
    }
  }, {
    key: "extractGoodsData",
    value: function extractGoodsData() {
      if (this.isDestroyed) return;
      try {
        this.log('开始提取商品数据');
        var data = window.rawData.store.initDataObj.goods;
        this.goodsId = data.goodsID;
        this.skusData = data.skus || [];

        // 提取groupId，从 groupTypes 数组的最后一个对象的 groupID 属性
        if (data.groupTypes && data.groupTypes.length > 0) {
          var lastGroupType = data.groupTypes[data.groupTypes.length - 1];
          this.groupId = lastGroupType.groupID || null;
        }
        this.log('商品数据提取成功:', {
          goodsId: this.goodsId,
          skusCount: this.skusData.length,
          groupId: this.groupId
        });

        // 记录SKU结构供调试
        if (this.skusData.length > 0) {
          this.log('SKU示例数据结构:', {
            firstSku: this.skusData[0],
            skuFields: Object.keys(this.skusData[0] || {})
          });
        }

        // 记录groupTypes结构供调试
        if (data.groupTypes) {
          this.log('groupTypes数据:', {
            groupTypes: data.groupTypes,
            count: data.groupTypes.length,
            lastGroupId: this.groupId
          });
        }
      } catch (error) {
        this.error('提取商品数据失败:', error);
      }
    }
  }, {
    key: "setupPurchaseButtonMonitor",
    value: function setupPurchaseButtonMonitor() {
      var _this4 = this;
      if (this.isDestroyed) return;
      this.log('开始设置全局点击监听器');

      // 添加节流控制，避免过于频繁的检查
      var clickThrottle = null;

      // 监听所有点击事件
      this.clickHandler = function (event) {
        if (_this4.isDestroyed) return;

        // 节流控制：500ms内只处理一次点击
        if (clickThrottle) return;
        clickThrottle = setTimeout(function () {
          clickThrottle = null;
        }, 500);
        var target = event.target;
        var text = target.textContent || '';
        var tagName = target.tagName || '';

        // 只记录重要的点击事件，减少日志输出
        if (tagName === 'BUTTON' || target.getAttribute('role') === 'button' || text.includes('去拼单') || text.includes('立即购买') || text.includes('加入购物车')) {
          _this4.log('检测到重要点击事件:', {
            tagName: tagName,
            textContent: text.substring(0, 30),
            role: target.getAttribute('role')
          });
        }

        // 延迟检查规格选择，给页面时间更新
        setTimeout(function () {
          if (!_this4.isDestroyed) {
            _this4.checkCurrentSpecs();
          }
        }, 300);
      };
      document.addEventListener('click', this.clickHandler, true);
      this.log('全局点击监听器已设置');
    }
  }, {
    key: "setupSpecificationMonitor",
    value: function setupSpecificationMonitor() {
      var _this5 = this;
      if (this.isDestroyed) return;
      this.log('开始设置DOM变化监听器');

      // 添加节流控制，避免过于频繁的DOM变化处理
      var domChangeThrottle = null;
      var changeCount = 0;

      // 监听DOM变化，但添加节流和过滤
      this.specObserver = new MutationObserver(function (mutations) {
        if (_this5.isDestroyed) return;

        // 节流控制：300ms内只处理一次DOM变化
        if (domChangeThrottle) {
          changeCount++;
          return;
        }
        domChangeThrottle = setTimeout(function () {
          domChangeThrottle = null;
          if (changeCount > 0) {
            _this5.log("DOM\u53D8\u5316\u8282\u6D41\u5904\u7406\uFF0C\u8DF3\u8FC7\u4E86".concat(changeCount, "\u6B21\u53D8\u5316"));
            changeCount = 0;
          }
        }, 300);
        var hasRelevantChange = false;

        // 只检查前5个变化，避免处理太多
        mutations.slice(0, 5).forEach(function (mutation) {
          if (mutation.type === 'characterData') {
            var newText = mutation.target.textContent || '';
            if (newText.includes('已选') || newText.includes('规格') || newText.includes('款式')) {
              hasRelevantChange = true;
            }
          }
          // 只关注重要的属性变化
          else if (mutation.type === 'attributes' && ['aria-selected', 'data-selected'].includes(mutation.attributeName)) {
            hasRelevantChange = true;
          }
        });
        if (hasRelevantChange) {
          _this5.log('检测到相关DOM变化');

          // 只进行一次延迟检查
          setTimeout(function () {
            if (!_this5.isDestroyed) {
              _this5.checkCurrentSpecs();
            }
          }, 200);
        }
      });

      // 监听document，但减少监听范围
      this.specObserver.observe(document, {
        childList: false,
        // 不监听子元素变化，减少触发频率
        subtree: true,
        attributes: true,
        characterData: true,
        attributeFilter: ['aria-selected', 'data-selected'] // 只监听关键属性
      });
      this.log('DOM变化监听器设置完成');

      // 增加定期检查间隔，从2秒改为5秒
      this.periodicSpecCheck = setInterval(function () {
        if (_this5.isDestroyed) {
          clearInterval(_this5.periodicSpecCheck);
          return;
        }
        _this5.log('定期检查规格');
        _this5.checkCurrentSpecs();
      }, 5000);

      // 移除滚动监听，减少触发频率
      this.log('规格变化监听器设置完成');
    }
  }, {
    key: "checkCurrentSpecs",
    value: function checkCurrentSpecs() {
      if (this.isDestroyed) return;
      this.log('开始检查当前选中的规格');

      // 只通过"已选："文本查找规格信息
      var selectedElement = this.findSelectedElement();
      if (selectedElement) {
        var selectedText = selectedElement.textContent;
        this.log('找到已选信息:', selectedText.substring(0, 100));
        this.parseSelectedSpecs(selectedText);
        this.matchSku();
        this.updateDisplay();
        return;
      }

      // 如果没有找到"已选："信息，尝试从URL参数获取SKU信息
      var urlParams = new URLSearchParams(window.location.search);
      var skuId = urlParams.get('sku_id') || urlParams.get('skuId');
      if (skuId) {
        this.log('从URL获取到SKU ID:', skuId);
        this.skuId = skuId;
        this.selectedSpecs = ['从URL获取'];
        this.updateDisplay();
        return;
      }
      this.log('未找到已选规格信息');
      // 清空之前的规格信息
      this.selectedSpecs = [];
      this.skuId = null;
      this.updateDisplay();
    }
  }, {
    key: "findSelectedElement",
    value: function findSelectedElement() {
      if (this.isDestroyed) return null;

      // 方法1：在dialog中查找已选信息（使用稳定的属性和结构）
      var dialogs = document.querySelectorAll('[role="dialog"]');
      var _iterator2 = _createForOfIteratorHelper(dialogs),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var dialog = _step2.value;
          // 在dialog顶部创建商品信息显示区域
          this.createInfoInDialog(dialog);

          // 查找包含"已选："文本的span元素
          var spans = dialog.querySelectorAll('span');
          var _iterator4 = _createForOfIteratorHelper(spans),
            _step4;
          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var span = _step4.value;
              var _text2 = span.textContent || '';
              if (_text2.includes('已选：')) {
                this.log('在dialog span中找到已选信息:', _text2.substring(0, 100));
                return span;
              }
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }
        }

        // 方法2：根据提供的xpath精确查找
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      var xpathResult = document.evaluate('//*[@id="main"]/div/div[2]/div[25]/div/div/div[1]/div/div[1]/div[3]/span', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
      if (xpathResult.singleNodeValue) {
        var element = xpathResult.singleNodeValue;
        var text = element.textContent || '';
        if (text.includes('已选')) {
          this.log('通过xpath找到已选元素:', text.substring(0, 100));
          return element;
        }
      }

      // 方法3：查找#main下div结构中的已选元素（更宽泛的匹配）
      var mainElement = document.getElementById('main');
      if (mainElement) {
        var possiblePaths = ['div/div[2]/div[25]/div/div/div[1]/div/div[1]/div[3]/span', 'div/div[2]/div[24]/div/div/div[1]/div/div[1]/div[3]/span', 'div/div[2]/div[26]/div/div/div[1]/div/div[1]/div[3]/span', 'div/div[2]/div[23]/div/div/div[1]/div/div[1]/div[3]/span'];
        for (var _i = 0, _possiblePaths = possiblePaths; _i < _possiblePaths.length; _i++) {
          var path = _possiblePaths[_i];
          try {
            var xpath = "//*[@id=\"main\"]/".concat(path);
            var result = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
            if (result.singleNodeValue) {
              var _element = result.singleNodeValue;
              var _text = _element.textContent || '';
              if (_text.includes('已选')) {
                this.log('通过变化xpath找到已选元素:', _text.substring(0, 100));
                return _element;
              }
            }
          } catch (e) {
            // xpath路径不存在，继续尝试下一个
          }
        }
      }

      // 方法4：全局搜索包含"已选："的span元素
      var allSpans = document.querySelectorAll('span');
      var _iterator3 = _createForOfIteratorHelper(allSpans),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _span = _step3.value;
          var _text3 = _span.textContent || '';
          if (_text3.includes('已选：') && _span.children.length === 0) {
            this.log('全局搜索找到已选信息元素:', _text3.substring(0, 100));
            return _span;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      this.log('未找到已选信息元素');
      return null;
    }
  }, {
    key: "parseSelectedSpecs",
    value: function parseSelectedSpecs(selectedText) {
      if (this.isDestroyed) return;
      try {
        this.log('解析规格文本:', selectedText.substring(0, 100));

        // 基于实际HTML结构解析：已选：裤头麦古怪-绿色 内裤系列-现货秒发
        var match = selectedText.match(/已选：(.+?)(?:\n|$)/);
        if (!match) {
          match = selectedText.match(/已选(.+?)(?:\n|$)/);
        }
        if (match) {
          var specsText = match[1].trim();
          this.log('提取的规格文本:', specsText);

          // 根据实际格式解析，可能的分隔符：空格、换行、制表符
          // 例如："裤头麦古怪-绿色 内裤系列-现货秒发"
          var specs = [];

          // 尝试按空格分割（最常见的情况）
          if (specsText.includes(' ')) {
            specs = specsText.split(/\s+/).filter(function (spec) {
              return spec.length > 0 && spec.length < 50;
            });
          }
          // 如果没有空格，可能是其他分隔符
          else if (specsText.includes(',') || specsText.includes('，') || specsText.includes('、')) {
            specs = specsText.split(/[,，、]+/).filter(function (spec) {
              return spec.trim().length > 0 && spec.trim().length < 50;
            });
          }
          // 如果没有明显分隔符，可能是连续的文本，尝试识别可能的规格项
          else {
            // 如果文本长度合理，作为单个规格处理
            if (specsText.length > 0 && specsText.length < 100) {
              specs = [specsText];
            } else {
              // 尝试按常见的中文规格模式分割
              var patterns = [/([^-\s]+?-[^-\s]+)/g,
              // 匹配 "xxx-xxx" 格式
              /([^:\s]{2,10}[系列|款|型|号][^:\s]*)/g // 匹配 "xxx系列" 等格式
              ];
              for (var _i2 = 0, _patterns = patterns; _i2 < _patterns.length; _i2++) {
                var pattern = _patterns[_i2];
                var matches = specsText.match(pattern);
                if (matches && matches.length > 0) {
                  specs = matches.filter(function (spec) {
                    return spec.length > 0 && spec.length < 50;
                  });
                  break;
                }
              }

              // 如果仍然没有解析出来，就整体作为一个规格
              if (specs.length === 0) {
                specs = [specsText];
              }
            }
          }
          this.selectedSpecs = specs.map(function (spec) {
            return spec.trim();
          }).filter(function (spec) {
            return spec.length > 0;
          });
          this.log('解析出的规格:', this.selectedSpecs);
        } else {
          this.log('无法从文本中提取规格信息');
          // 如果没有"已选："标记，但文本本身可能就是规格信息
          if (selectedText.trim().length > 0 && selectedText.trim().length < 100) {
            this.selectedSpecs = [selectedText.trim()];
            this.log('将整个文本作为规格:', this.selectedSpecs);
          }
        }
      } catch (error) {
        this.error('解析规格失败:', error);
      }
    }
  }, {
    key: "matchSku",
    value: function matchSku() {
      var _this6 = this;
      if (this.isDestroyed || !this.skusData || !this.selectedSpecs.length) {
        return;
      }
      try {
        this.log('开始匹配SKU:', {
          selectedSpecs: this.selectedSpecs,
          totalSkus: this.skusData.length
        });

        // 查找匹配的SKU
        var matchedSku = this.skusData.find(function (sku) {
          if (!sku.specs) return false;

          // 检查每个选中的规格值是否都在SKU的specs中
          return _this6.selectedSpecs.every(function (selectedSpec) {
            return sku.specs.some(function (spec) {
              return spec.spec_value && spec.spec_value.includes(selectedSpec);
            });
          });
        });
        if (matchedSku) {
          this.skuId = matchedSku.skuId;

          // 提取价格和库存信息
          this.skuInfo = {
            quantity: matchedSku.quantity || null,
            groupPrice: matchedSku.groupPrice || null,
            normalPrice: matchedSku.normalPrice || null
          };
          this.log('匹配成功:', {
            skuId: this.skuId,
            goodsId: matchedSku.goodsId || this.goodsId,
            skuInfo: this.skuInfo
          });

          // 记录完整的SKU数据结构用于调试
          this.log('匹配的SKU完整数据:', matchedSku);
        } else {
          this.skuId = null;
          // 清空价格和库存信息
          this.skuInfo = {
            quantity: null,
            groupPrice: null,
            normalPrice: null
          };
          this.log('未找到匹配的SKU');

          // 记录前几个SKU的规格信息用于调试
          this.skusData.slice(0, 3).forEach(function (sku, index) {
            var _sku$specs;
            _this6.log("SKU".concat(index, " \u89C4\u683C\u4FE1\u606F:"), {
              specs: (_sku$specs = sku.specs) === null || _sku$specs === void 0 ? void 0 : _sku$specs.map(function (s) {
                return s.spec_value;
              }),
              quantity: sku.quantity,
              groupPrice: sku.groupPrice,
              normalPrice: sku.normalPrice,
              skuId: sku.skuId
            });
          });
        }
      } catch (error) {
        this.error('匹配SKU失败:', error);
      }
    }
  }, {
    key: "createInfoInDialog",
    value: function createInfoInDialog(dialog) {
      if (this.isDestroyed) return;

      // 🔧 设置 role="dialog" 上一层 div 的 height 为 10rem
      var parentDiv = dialog.parentElement;
      if (parentDiv && parentDiv.tagName === 'DIV') {
        parentDiv.style.height = '10rem';
        this.log('已设置dialog父级div高度为10rem');
      }

      // 检查是否已经在这个dialog中创建了信息区域
      var existingInfo = dialog.querySelector('#goods-detail-info-in-dialog');
      if (existingInfo) {
        this.dialogInfoBar = existingInfo;
        this.updateDialogDisplay();
        return;
      }
      this.log('在dialog中创建商品信息显示区域');

      // 创建商品信息显示区域
      var infoDiv = document.createElement('div');
      infoDiv.id = 'goods-detail-info-in-dialog';
      infoDiv.style.cssText = "\n            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);\n            border: 1px solid #dee2e6;\n            border-radius: 8px;\n            padding: 5px;\n            width: 100%;\n            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;\n            box-shadow: 0 2px 8px rgba(0,0,0,0.05);\n        ";

      // 将信息区域插入到dialog的最顶部
      var firstChild = dialog.firstElementChild;
      if (firstChild) {
        dialog.insertBefore(infoDiv, firstChild);
      } else {
        dialog.appendChild(infoDiv);
      }
      this.dialogInfoBar = infoDiv;
      this.updateDialogDisplay();
      this.log('dialog中的商品信息区域创建完成');
    }
  }, {
    key: "updateDialogDisplay",
    value: function updateDialogDisplay() {
      if (this.isDestroyed || !this.dialogInfoBar) return;
      var goodsIdText = this.goodsId ? this.goodsId : '未获取';
      var skuIdText = this.skuId ? this.skuId : '未选择';

      // 构建价格和库存信息字符串
      var priceStockInfo = '';
      if (this.skuId && (this.skuInfo.normalPrice || this.skuInfo.groupPrice || this.skuInfo.quantity)) {
        var priceStockParts = [];
        if (this.skuInfo.normalPrice) {
          priceStockParts.push("\u5355\u4EF7:".concat(this.skuInfo.normalPrice));
        }
        if (this.skuInfo.groupPrice) {
          priceStockParts.push("\u62FC\u56E2\u4EF7:".concat(this.skuInfo.groupPrice));
        }
        if (this.skuInfo.quantity !== null && this.skuInfo.quantity !== undefined) {
          priceStockParts.push("\u5E93\u5B58:".concat(this.skuInfo.quantity));
        }
        if (priceStockParts.length > 0) {
          priceStockInfo = priceStockParts.join(' / ');
        }
      }

      // 构建拼单链接
      var groupPurchaseLink = '';
      if (this.goodsId && this.skuId && this.groupId) {
        groupPurchaseLink = "https://mobile.yangkeduo.com/order_checkout.html?sku_id=".concat(this.skuId, "&group_id=").concat(this.groupId, "&goods_id=").concat(this.goodsId, "&goods_number=1");
      }
      this.dialogInfoBar.innerHTML = "\n            <div style=\"display: flex; flex-direction: column; gap: 5px;\">\n                <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 8px; background: rgba(255,255,255,0.7); border-radius: 4px;\">\n                    <div style=\"display: flex; align-items: center; gap: 8px;\">\n                        <span style=\"color: #666; font-size: 13px; font-weight: 500;\">\u5546\u54C1ID:</span>\n                        <span style=\"color: #e02e24; font-weight: 600; font-size: 14px; font-family: monospace;\">".concat(goodsIdText, "</span>\n                    </div>\n                    <button \n                        onclick=\"navigator.clipboard.writeText('").concat(goodsIdText, "').then(() => { \n                            const btn = this; \n                            const oldText = btn.textContent; \n                            btn.textContent = '\u2713\u5DF2\u590D\u5236'; \n                            btn.style.background = '#4caf50'; \n                            setTimeout(() => { \n                                btn.textContent = oldText; \n                                btn.style.background = '#007bff'; \n                            }, 1000); \n                        })\" \n                        style=\"\n                            background: #007bff; \n                            color: white; \n                            border: none; \n                            padding: 4px 8px; \n                            border-radius: 4px; \n                            font-size: 11px; \n                            cursor: pointer;\n                            transition: all 0.2s ease;\n                        \"\n                        onmouseover=\"this.style.background='#0056b3'\"\n                        onmouseout=\"this.style.background='#007bff'\"\n                    >\u590D\u5236</button>\n                </div>\n                <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 8px; background: rgba(255,255,255,0.7); border-radius: 4px;\">\n                    <div style=\"display: flex; align-items: center; gap: 8px;\">\n                        <span style=\"color: #666; font-size: 13px; font-weight: 500;\">\u89C4\u683CID:</span>\n                        <span style=\"color: #4caf50; font-weight: 600; font-size: 14px; font-family: monospace;\">").concat(skuIdText, "</span>\n                    </div>\n                    <button \n                        onclick=\"navigator.clipboard.writeText('").concat(skuIdText, "').then(() => { \n                            const btn = this; \n                            const oldText = btn.textContent; \n                            btn.textContent = '\u2713\u5DF2\u590D\u5236'; \n                            btn.style.background = '#4caf50'; \n                            setTimeout(() => { \n                                btn.textContent = oldText; \n                                btn.style.background = '#007bff'; \n                            }, 1000); \n                        })\" \n                        style=\"\n                            background: #007bff; \n                            color: white; \n                            border: none; \n                            padding: 4px 8px; \n                            border-radius: 4px; \n                            font-size: 11px; \n                            cursor: pointer;\n                            transition: all 0.2s ease;\n                        \"\n                        onmouseover=\"this.style.background='#0056b3'\"\n                        onmouseout=\"this.style.background='#007bff'\"\n                    >\u590D\u5236</button>\n                </div>\n                ").concat(this.selectedSpecs.length ? "\n                <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 6px 8px; background: rgba(255,255,255,0.7); border-radius: 4px; border-left: 3px solid #28a745;\">\n                    <div style=\"display: flex; align-items: center; gap: 8px;\">\n                        <span style=\"color: #666; font-size: 12px; font-weight: 500;\">\u5DF2\u9009\u89C4\u683C:</span>\n                        <span style=\"color: #28a745; font-size: 12px; font-weight: 500;\">".concat(this.selectedSpecs.join(' | '), "</span>\n                    </div>\n                    <button \n                        onclick=\"navigator.clipboard.writeText('").concat(this.selectedSpecs.join(' | '), "').then(() => { \n                            const btn = this; \n                            const oldText = btn.textContent; \n                            btn.textContent = '\u2713\u5DF2\u590D\u5236'; \n                            btn.style.background = '#4caf50'; \n                            setTimeout(() => { \n                                btn.textContent = oldText; \n                                btn.style.background = '#007bff'; \n                            }, 1000); \n                        })\" \n                        style=\"\n                            background: #007bff; \n                            color: white; \n                            border: none; \n                            padding: 4px 8px; \n                            border-radius: 4px; \n                            font-size: 11px; \n                            cursor: pointer;\n                            transition: all 0.2s ease;\n                        \"\n                        onmouseover=\"this.style.background='#0056b3'\"\n                        onmouseout=\"this.style.background='#007bff'\"\n                    >\u590D\u5236</button>\n                </div>\n                ") : '', "\n                ").concat(priceStockInfo ? "\n                <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 6px 8px; background: rgba(255,255,255,0.7); border-radius: 4px; border-left: 3px solid #ff6b35;\">\n                    <div style=\"display: flex; align-items: center; gap: 8px;\">\n                        <span style=\"color: #666; font-size: 12px; font-weight: 500;\">\u89C4\u683C\u4FE1\u606F:</span>\n                        <span style=\"color: #ff6b35; font-size: 12px; font-weight: 500;\">".concat(priceStockInfo, "</span>\n                    </div>\n                    <button \n                        onclick=\"navigator.clipboard.writeText('").concat(priceStockInfo, "').then(() => { \n                            const btn = this; \n                            const oldText = btn.textContent; \n                            btn.textContent = '\u2713\u5DF2\u590D\u5236'; \n                            btn.style.background = '#4caf50'; \n                            setTimeout(() => { \n                                btn.textContent = oldText; \n                                btn.style.background = '#007bff'; \n                            }, 1000); \n                        })\" \n                        style=\"\n                            background: #007bff; \n                            color: white; \n                            border: none; \n                            padding: 4px 8px; \n                            border-radius: 4px; \n                            font-size: 11px; \n                            cursor: pointer;\n                            transition: all 0.2s ease;\n                        \"\n                        onmouseover=\"this.style.background='#0056b3'\"\n                        onmouseout=\"this.style.background='#007bff'\"\n                    >\u590D\u5236</button>\n                </div>\n                ") : '', "\n                ").concat(groupPurchaseLink ? "\n                <div style=\"display: flex; justify-content: space-between; align-items: center; padding: 8px; background: rgba(255,255,255,0.7); border-radius: 4px; border-left: 3px solid #9c27b0;\">\n                    <div style=\"display: flex; align-items: center; gap: 8px; flex: 1;\">\n                        <span style=\"color: #666; font-size: 12px; font-weight: 500;\">\u62FC\u5355\u94FE\u63A5:</span>\n                        <span style=\"color: #9c27b0; font-size: 11px; font-weight: 500; word-break: break-all; flex: 1;\">".concat(groupPurchaseLink, "</span>\n                    </div>\n                    <button \n                        onclick=\"navigator.clipboard.writeText('").concat(groupPurchaseLink, "').then(() => { \n                            const btn = this; \n                            const oldText = btn.textContent; \n                            btn.textContent = '\u2713\u5DF2\u590D\u5236'; \n                            btn.style.background = '#4caf50'; \n                            setTimeout(() => { \n                                btn.textContent = oldText; \n                                btn.style.background = '#007bff'; \n                            }, 1000); \n                        })\" \n                        style=\"\n                            background: #007bff; \n                            color: white; \n                            border: none; \n                            padding: 4px 8px; \n                            border-radius: 4px; \n                            font-size: 11px; \n                            cursor: pointer;\n                            transition: all 0.2s ease;\n                            margin-left: 8px;\n                            flex-shrink: 0;\n                        \"\n                        onmouseover=\"this.style.background='#0056b3'\"\n                        onmouseout=\"this.style.background='#007bff'\"\n                    >\u590D\u5236</button>\n                </div>\n                ") : '', "\n                <div style=\"text-align: center; padding: 4px 8px; font-size: 12px; color: #666; margin-top: 5px;\">\n                    \u4EE5\u4E0A\u4FE1\u606F\u7531<span style=\"color: #1890ff; font-weight: 500;\">\u591A\u591A\u5F00</span>\u63D0\u4F9B\u6280\u672F\u652F\u6301\n                    <p style=\"color: #ff4d4f; font-weight: 500; font-size:\">\u540C\u4E00\u8D26\u53F7\u9891\u7E41\u6253\u5F00\u5546\u54C1\u8BE6\u60C5\u9875\u9762\uFF0C\u62FC\u591A\u591A\u53EF\u80FD\u5C06\u60A8\u8D26\u53F7\u4F1A\u8BEF\u5224\u8FDD\u89C4\u91C7\u96C6\u5546\u54C1\uFF0C\u4F1A\u6709\u8D26\u53F7\u98CE\u63A7\u98CE\u9669\uFF0C\u8BF7\u8C28\u614E\u4F7F\u7528\uFF01</p>\n                </div>\n            </div>\n        ");
    }
  }, {
    key: "createInfoBar",
    value: function createInfoBar() {
      // 不再创建页面顶部的信息条，因为我们现在在dialog中显示
      this.log('跳过创建页面顶部信息条，将在dialog中显示');
    }
  }, {
    key: "updateDisplay",
    value: function updateDisplay() {
      var customMessage = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      if (this.isDestroyed) return;

      // 如果有dialog信息条，更新dialog中的显示
      if (this.dialogInfoBar) {
        this.updateDialogDisplay();
      }

      // 保持原有的页面顶部信息条逻辑（如果存在）
      if (!this.infoBar) return;
      if (customMessage) {
        this.infoBar.innerHTML = "\n                <div style=\"text-align: center; color: #666; font-size: 12px;\">\n                    ".concat(customMessage, "\n                </div>\n            ");
        return;
      }
      var goodsIdText = this.goodsId ? this.goodsId : '未获取';
      var skuIdText = this.skuId ? this.skuId : '未选择';
      this.infoBar.innerHTML = "\n            <div style=\"display: flex; flex-direction: column; gap: 2px;\">\n                <div style=\"font-size: 12px;\">\n                    <span style=\"color: #666;\">\u5546\u54C1ID: </span>\n                    <span style=\"color: #e02e24; font-weight: bold;\">".concat(goodsIdText, "</span>\n                </div>\n                <div style=\"font-size: 12px;\">\n                    <span style=\"color: #666;\">\u89C4\u683CID: </span>\n                    <span style=\"color: #4caf50; font-weight: bold;\">").concat(skuIdText, "</span>\n                </div>\n                ").concat(this.selectedSpecs.length ? "\n                <div style=\"font-size: 10px; color: #888; margin-top: 2px;\">\n                    \u5DF2\u9009: ".concat(this.selectedSpecs.join(' | '), "\n                </div>\n                ") : '', "\n            </div>\n        ");

      // 根据是否有SKU调整背景颜色
      if (this.skuId) {
        this.infoBar.style.backgroundColor = '#f0f9f0';
        this.infoBar.style.borderColor = '#4caf50';
      } else {
        this.infoBar.style.backgroundColor = '#f0f8ff';
        this.infoBar.style.borderColor = '#e0e0e0';
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.isDestroyed = true;
      this.log('销毁助手');

      // 清理定时器
      if (this.checkInterval) {
        clearInterval(this.checkInterval);
        this.checkInterval = null;
      }
      if (this.periodicSpecCheck) {
        clearInterval(this.periodicSpecCheck);
        this.periodicSpecCheck = null;
      }

      // 清理事件监听器
      if (this.clickHandler) {
        document.removeEventListener('click', this.clickHandler, true);
        this.clickHandler = null;
      }

      // 清理观察器
      if (this.observer) {
        this.observer.disconnect();
        this.observer = null;
      }
      if (this.dataObserver) {
        this.dataObserver.disconnect();
        this.dataObserver = null;
      }
      if (this.specObserver) {
        this.specObserver.disconnect();
        this.specObserver = null;
      }

      // 清理特定区域观察器
      if (this.specificObservers) {
        this.specificObservers.forEach(function (observer) {
          return observer.disconnect();
        });
        this.specificObservers = null;
      }

      // 清理DOM
      if (this.infoBar) {
        this.infoBar.remove();
        this.infoBar = null;
      }

      // 清理dialog中的信息条
      if (this.dialogInfoBar) {
        this.dialogInfoBar.remove();
        this.dialogInfoBar = null;
      }

      // 也清理所有可能存在的dialog中的信息条
      var dialogInfos = document.querySelectorAll('#goods-detail-info-in-dialog');
      dialogInfos.forEach(function (info) {
        return info.remove();
      });

      // 恢复页面样式
      var container = document.querySelector('.goods-container-v2') || document.querySelector('#main');
      if (container) {
        container.style.marginTop = '';
      }
    }
  }]);
}(); // 页面加载时初始化
var goodsDetailHelper = null;
console.log('商品详情助手脚本加载');
console.log('当前页面URL:', window.location.href);
console.log('页面标题:', document.title);

// 检查是否在商品详情页面
var isGoodsPage = (window.location.hostname.includes('mobile.yangkeduo.com') || window.location.hostname.includes('yangkeduo.com')) && (window.location.pathname.includes('/goods') || window.location.search.includes('goods_id'));
console.log('是否为商品页面:', isGoodsPage);
if (isGoodsPage) {
  console.log('确认是商品页面，准备初始化助手');

  // 立即尝试初始化
  var tryInit = function tryInit() {
    console.log('尝试初始化商品详情助手');
    if (!goodsDetailHelper) {
      goodsDetailHelper = new GoodsDetailHelper();
    }
  };

  // 多种时机尝试初始化
  if (document.readyState === 'complete') {
    console.log('页面已完全加载，立即初始化');
    tryInit();
  } else if (document.readyState === 'interactive') {
    console.log('DOM已加载，延迟500ms初始化');
    setTimeout(tryInit, 500);
  } else {
    console.log('页面还在加载，等待DOMContentLoaded事件');
    document.addEventListener('DOMContentLoaded', function () {
      console.log('DOMContentLoaded事件触发，延迟100ms初始化');
      setTimeout(tryInit, 100);
    });
  }

  // 保险起见，再设置一个延迟初始化
  setTimeout(function () {
    if (!goodsDetailHelper) {
      console.log('兜底初始化触发');
      tryInit();
    } else {
      console.log('助手已存在，跳过兜底初始化');
    }
  }, 2000);

  // 监听页面加载完成事件
  window.addEventListener('load', function () {
    console.log('window.load事件触发');
    if (!goodsDetailHelper) {
      console.log('load事件后初始化');
      tryInit();
    }
  });
}

// 页面卸载时清理
window.addEventListener('beforeunload', function () {
  console.log('页面即将卸载，清理助手');
  if (goodsDetailHelper) {
    goodsDetailHelper.destroy();
  }
});

// 监听页面可见性变化
document.addEventListener('visibilitychange', function () {
  console.log('页面可见性变化:', document.visibilityState);
  if (document.visibilityState === 'visible' && goodsDetailHelper) {
    // 页面变为可见时，重新检查规格
    console.log('页面变为可见，检查规格状态');
    setTimeout(function () {
      if (goodsDetailHelper && !goodsDetailHelper.isDestroyed) {
        goodsDetailHelper.checkCurrentSpecs();
      }
    }, 500);
  }
});

// 监听URL变化（单页应用可能会动态改变URL）
var lastUrl = window.location.href;
var checkUrlChange = function checkUrlChange() {
  var currentUrl = window.location.href;
  if (currentUrl !== lastUrl) {
    console.log('URL发生变化:', lastUrl, '->', currentUrl);
    lastUrl = currentUrl;

    // 如果URL变化到新的商品页面，重新初始化
    var isNewGoodsPage = (currentUrl.includes('mobile.yangkeduo.com') || currentUrl.includes('yangkeduo.com')) && (currentUrl.includes('/goods') || currentUrl.includes('goods_id'));
    if (isNewGoodsPage && !goodsDetailHelper) {
      console.log('检测到新的商品页面，重新初始化');
      setTimeout(function () {
        if (!goodsDetailHelper) {
          goodsDetailHelper = new GoodsDetailHelper();
        }
      }, 1000);
    }
  }
};

// 定期检查URL变化
setInterval(checkUrlChange, 1000);

// 导出供其他脚本使用
window.GoodsDetailHelper = GoodsDetailHelper;

// 添加调试函数到全局作用域
window.debugGoodsHelper = function () {
  if (goodsDetailHelper) {
    var _goodsDetailHelper$sk;
    console.log('助手状态:', {
      isDestroyed: goodsDetailHelper.isDestroyed,
      goodsId: goodsDetailHelper.goodsId,
      skuId: goodsDetailHelper.skuId,
      groupId: goodsDetailHelper.groupId,
      selectedSpecs: goodsDetailHelper.selectedSpecs,
      skusDataCount: ((_goodsDetailHelper$sk = goodsDetailHelper.skusData) === null || _goodsDetailHelper$sk === void 0 ? void 0 : _goodsDetailHelper$sk.length) || 0
    });

    // 手动触发规格检查
    console.log('手动触发规格检查');
    goodsDetailHelper.checkCurrentSpecs();
  } else {
    console.log('助手未初始化');
  }
};

// 商品数据采集和导出功能
var GoodsDataCollector = /*#__PURE__*/function () {
  function GoodsDataCollector() {
    _classCallCheck(this, GoodsDataCollector);
    console.log('商品数据采集器已初始化');
  }

  // 从页面提取商品数据
  return _createClass(GoodsDataCollector, [{
    key: "extractGoodsData",
    value: function extractGoodsData() {
      try {
        var _window$rawData;
        var data = (_window$rawData = window.rawData) === null || _window$rawData === void 0 || (_window$rawData = _window$rawData.store) === null || _window$rawData === void 0 || (_window$rawData = _window$rawData.initDataObj) === null || _window$rawData === void 0 ? void 0 : _window$rawData.goods;
        if (!data) {
          throw new Error('无法获取商品数据，请确保页面已完全加载');
        }
        console.log('原始商品数据:', data);

        // 获取当前页面URL
        var currentUrl = window.location.href;

        // 提取商品属性
        var attributes = [];
        if (data.goodsProperty && Array.isArray(data.goodsProperty)) {
          data.goodsProperty.forEach(function (prop) {
            if (prop.key && prop.values && prop.values.length > 0) {
              attributes.push("".concat(prop.key, "\uFF1A").concat(prop.values.join('、')));
            }
          });
        }

        // 获取商品主图列表（从 viewImageData 获取）
        var mainImages = [];
        if (data.viewImageData && Array.isArray(data.viewImageData)) {
          data.viewImageData.forEach(function (url) {
            if (url) {
              // 清理图片URL，移除查询参数中的尺寸限制
              var cleanUrl = url.split('?')[0];
              mainImages.push(cleanUrl);
            }
          });
        }
        // 如果没有viewImageData，尝试使用gallery
        if (mainImages.length === 0 && data.gallery && Array.isArray(data.gallery)) {
          data.gallery.forEach(function (img) {
            if (img && img.url) {
              var cleanUrl = img.url.split('?')[0];
              mainImages.push(cleanUrl);
            }
          });
        }
        // 如果还是没有，尝试使用thumbUrl
        if (mainImages.length === 0 && data.thumbUrl) {
          var cleanUrl = data.thumbUrl.split('?')[0];
          mainImages.push(cleanUrl);
        }

        // 获取详情图列表
        var detailImages = [];
        if (data.detailGallery && Array.isArray(data.detailGallery)) {
          data.detailGallery.forEach(function (img) {
            if (img && img.url) {
              // 清理图片URL
              var _cleanUrl = img.url.split('?')[0];
              detailImages.push(_cleanUrl);
            }
          });
        }

        // 获取视频链接（从 videoGallery 获取）
        var videoUrl = '';
        if (data.videoGallery && Array.isArray(data.videoGallery) && data.videoGallery.length > 0) {
          // videoGallery 是一个数组，取第一个视频
          var firstVideo = data.videoGallery[0];
          if (typeof firstVideo === 'string') {
            videoUrl = firstVideo;
          } else if (firstVideo && firstVideo.url) {
            videoUrl = firstVideo.url;
          } else if (firstVideo && firstVideo.videoUrl) {
            videoUrl = firstVideo.videoUrl;
          }
        }
        // 如果videoGallery没有，尝试使用video对象
        if (!videoUrl && data.video && data.video.videoUrl) {
          videoUrl = data.video.videoUrl;
        }

        // 提取groupId（从 groupTypes 数组的最后一个对象的 groupID 属性）
        var groupId = '';
        if (data.groupTypes && Array.isArray(data.groupTypes) && data.groupTypes.length > 0) {
          var lastGroupType = data.groupTypes[data.groupTypes.length - 1];
          groupId = lastGroupType.groupID || '';
        }

        // 基础商品信息
        var goodsInfo = {
          goodsId: data.goodsID || '',
          goodsName: (data.goodsName || '').trim(),
          currency: 'CNY',
          mainImages: mainImages,
          sourceUrl: currentUrl,
          sourcePlatform: '拼多多',
          sourceGoodsId: data.goodsID || '',
          description: attributes.join('_x000d_\n'),
          detailImages: detailImages,
          category: data.catName || '',
          attributes: attributes.join('_x000d_；'),
          videoUrl: videoUrl,
          groupId: groupId,
          skus: data.skus || []
        };
        console.log('提取的商品信息:', {
          goodsId: goodsInfo.goodsId,
          goodsName: goodsInfo.goodsName,
          mainImagesCount: goodsInfo.mainImages.length,
          detailImagesCount: goodsInfo.detailImages.length,
          skusCount: goodsInfo.skus.length
        });
        return goodsInfo;
      } catch (error) {
        console.error('提取商品数据失败:', error);
        throw error;
      }
    }

    // 生成Excel数据（按店八方模板格式）
  }, {
    key: "generateExcelData",
    value: function generateExcelData(goodsInfo) {
      var rows = [];
      console.log('开始生成Excel数据，SKU数量:', goodsInfo.skus.length);

      // 如果有SKU，为每个SKU生成一行
      if (goodsInfo.skus && goodsInfo.skus.length > 0) {
        goodsInfo.skus.forEach(function (sku, index) {
          try {
            // 提取SKU规格
            var specs = sku.specs || [];
            var spec1 = specs[0] ? "".concat(specs[0].spec_key, ":").concat(specs[0].spec_value) : '';
            var spec2 = specs[1] ? "".concat(specs[1].spec_key, ":").concat(specs[1].spec_value) : '';

            // 获取SKU图片
            var skuImages = [];
            if (sku.thumbUrl) {
              var cleanUrl = sku.thumbUrl.split('?')[0];
              skuImages.push(cleanUrl);
            }
            // 如果SKU有多个图片，添加到列表
            if (sku.gallery && Array.isArray(sku.gallery)) {
              sku.gallery.forEach(function (img) {
                if (img && img.url) {
                  var _cleanUrl2 = img.url.split('?')[0];
                  if (_cleanUrl2 !== sku.thumbUrl && !skuImages.includes(_cleanUrl2)) {
                    skuImages.push(_cleanUrl2);
                  }
                }
              });
            }

            // 如果SKU没有图片，使用商品主图
            if (skuImages.length === 0 && goodsInfo.mainImages.length > 0) {
              skuImages.push(goodsInfo.mainImages[0]);
            }

            // 构建拼单链接
            var groupPurchaseLink = "https://mobile.yangkeduo.com/order_checkout.html?sku_id=".concat(sku.skuId, "&group_id=").concat(goodsInfo.groupId, "&goods_id=").concat(goodsInfo.goodsId, "&goods_number=1");
            var row = {
              '产品主编号': String(goodsInfo.goodsId || ''),
              '产品名称': goodsInfo.goodsName,
              '货币': goodsInfo.currency,
              '产品图片': goodsInfo.mainImages.join('，'),
              '货源链接': goodsInfo.sourceUrl,
              '货源平台名称': goodsInfo.sourcePlatform,
              '采集来源产品ID': String(goodsInfo.sourceGoodsId || ''),
              '产品详情描述': goodsInfo.description,
              '详情图': goodsInfo.detailImages.join('，'),
              '产品所属类目': goodsInfo.category || '',
              '产品属性': goodsInfo.attributes,
              '视频链接': goodsInfo.videoUrl || '',
              'SKU规格名称1': spec1,
              'SKU规格名称2': spec2,
              '平台SKU编号': String(sku.skuId || ''),
              'SKU售价': sku.groupPrice || '',
              'SKU图片': skuImages.join('，'),
              'SKU库存': sku.quantity || 0,
              'SKU重量': sku.weight || '',
              'SKU尺寸': '',
              '拼单链接': groupPurchaseLink
            };
            rows.push(row);
            console.log("SKU ".concat(index + 1, "/").concat(goodsInfo.skus.length, " \u5904\u7406\u5B8C\u6210:"), {
              skuId: sku.skuId,
              spec1: spec1,
              spec2: spec2,
              price: row['SKU售价'],
              stock: row['SKU库存']
            });
          } catch (error) {
            console.error("\u5904\u7406SKU ".concat(index + 1, " \u5931\u8D25:"), error, sku);
          }
        });
      } else {
        // 没有SKU时，生成一行基础信息
        console.log('商品没有SKU，生成基础信息行');

        // 构建拼单链接（没有SKU时不包含sku_id）
        var groupPurchaseLink = "https://mobile.yangkeduo.com/goods.html?goods_id=".concat(goodsInfo.goodsId);
        var row = {
          '产品主编号': goodsInfo.goodsId,
          '产品名称': goodsInfo.goodsName,
          '货币': goodsInfo.currency,
          '产品图片': goodsInfo.mainImages.join('，'),
          '货源链接': goodsInfo.sourceUrl,
          '货源平台名称': goodsInfo.sourcePlatform,
          '采集来源产品ID': goodsInfo.sourceGoodsId,
          '产品详情描述': goodsInfo.description,
          '详情图': goodsInfo.detailImages.join('，'),
          '产品所属类目': goodsInfo.category || '',
          '产品属性': goodsInfo.attributes,
          '视频链接': goodsInfo.videoUrl || '',
          'SKU规格名称1': '',
          'SKU规格名称2': '',
          '平台SKU编号': '',
          'SKU售价': '',
          'SKU图片': '',
          'SKU库存': '',
          'SKU重量': '',
          'SKU尺寸': '',
          '拼单链接': groupPurchaseLink
        };
        rows.push(row);
      }
      console.log("Excel\u6570\u636E\u751F\u6210\u5B8C\u6210\uFF0C\u5171 ".concat(rows.length, " \u884C"));
      return rows;
    }

    // 导出Excel文件（发送数据到background script）
  }, {
    key: "exportToExcel",
    value: function () {
      var _exportToExcel = goodsDetailHelper_asyncToGenerator(/*#__PURE__*/goodsDetailHelper_regeneratorRuntime().mark(function _callee() {
        var goodsInfo, rows, sanitizedName, fileName, colWidths, response;
        return goodsDetailHelper_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              // 提取商品数据
              goodsInfo = this.extractGoodsData(); // 生成Excel数据
              rows = this.generateExcelData(goodsInfo);
              console.log('生成的Excel数据:', rows);

              // 生成文件名（移除特殊字符）
              sanitizedName = goodsInfo.goodsName.substring(0, 20).replace(/[<>:"/\\|?*\x00-\x1f]/g, '') // 移除Windows文件名非法字符
              .replace(/\s+/g, '_') // 空格替换为下划线
              .trim();
              fileName = "".concat(sanitizedName, "_").concat(goodsInfo.goodsId, ".xlsx"); // 列宽配置
              colWidths = [{
                wch: 15
              },
              // 产品主编号
              {
                wch: 50
              },
              // 产品名称
              {
                wch: 8
              },
              // 货币
              {
                wch: 100
              },
              // 产品图片
              {
                wch: 80
              },
              // 货源链接
              {
                wch: 12
              },
              // 货源平台名称
              {
                wch: 15
              },
              // 采集来源产品ID
              {
                wch: 50
              },
              // 产品详情描述
              {
                wch: 100
              },
              // 详情图
              {
                wch: 20
              },
              // 产品所属类目
              {
                wch: 50
              },
              // 产品属性
              {
                wch: 80
              },
              // 视频链接
              {
                wch: 30
              },
              // SKU规格名称1
              {
                wch: 30
              },
              // SKU规格名称2
              {
                wch: 20
              },
              // 平台SKU编号
              {
                wch: 10
              },
              // SKU售价
              {
                wch: 80
              },
              // SKU图片
              {
                wch: 10
              },
              // SKU库存
              {
                wch: 10
              },
              // SKU重量
              {
                wch: 10
              },
              // SKU尺寸
              {
                wch: 100
              } // 拼单链接
              ]; // 发送数据到background script进行下载
              _context.next = 9;
              return chrome.runtime.sendMessage({
                action: 'exportGoodsData',
                data: {
                  rows: rows,
                  fileName: fileName,
                  colWidths: colWidths
                }
              });
            case 9:
              response = _context.sent;
              if (!(response && response.success)) {
                _context.next = 15;
                break;
              }
              console.log('导出成功:', fileName);
              return _context.abrupt("return", true);
            case 15:
              throw new Error((response === null || response === void 0 ? void 0 : response.error) || '导出失败');
            case 16:
              _context.next = 23;
              break;
            case 18:
              _context.prev = 18;
              _context.t0 = _context["catch"](0);
              console.error('导出失败:', _context.t0);
              alert("\u5BFC\u51FA\u5931\u8D25: ".concat(_context.t0.message));
              return _context.abrupt("return", false);
            case 23:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[0, 18]]);
      }));
      function exportToExcel() {
        return _exportToExcel.apply(this, arguments);
      }
      return exportToExcel;
    }() // 创建采集按钮（带权限检查）
  }, {
    key: "createCollectButton",
    value: function () {
      var _createCollectButton = goodsDetailHelper_asyncToGenerator(/*#__PURE__*/goodsDetailHelper_regeneratorRuntime().mark(function _callee4() {
        var _this7 = this;
        var currentUser, hasPermission, buttonContainer, baseStyle, text;
        return goodsDetailHelper_regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              if (!document.getElementById('goods-collect-button')) {
                _context4.next = 2;
                break;
              }
              return _context4.abrupt("return");
            case 2:
              // 清除缓存，获取最新用户信息
              clearUserCache();

              // 检查用户权限
              _context4.next = 5;
              return getCurrentUser();
            case 5:
              currentUser = _context4.sent;
              if (currentUser) {
                _context4.next = 9;
                break;
              }
              console.log('用户未登录，不显示商品采集按钮');
              return _context4.abrupt("return");
            case 9:
              // 商品采集权限：试用用户有效期内可用，专业和高级套餐可用
              // 与批量下单相同的权限：hasBatchPermission
              hasPermission = currentUser.hasBatchPermission;
              console.log('商品采集 - 用户权限:', {
                username: currentUser.username,
                package_name: currentUser.package_name,
                hasBatchPermission: hasPermission
              });

              // 创建按钮容器
              buttonContainer = document.createElement('div');
              buttonContainer.id = 'goods-collect-button';

              // 基础样式
              baseStyle = "\n            position: fixed;\n            bottom: 1.2rem;\n            right: 0.2rem;\n            z-index: 10000;\n            color: white;\n            padding: 0.12rem 0.16rem;\n            border-radius: 0.25rem;\n            box-shadow: 0 0.04rem 0.12rem rgba(0,0,0,0.3);\n            cursor: pointer;\n            font-size: 0.14rem;\n            font-weight: 600;\n            transition: all 0.3s ease;\n            display: flex;\n            align-items: center;\n            gap: 0.08rem;\n        "; // 添加文字
              text = document.createElement('span');
              if (hasPermission) {
                // 有权限：正常功能按钮
                buttonContainer.style.cssText = baseStyle + "\n                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            ";
                text.textContent = '采集商品';

                // 添加悬停效果
                buttonContainer.onmouseover = function () {
                  buttonContainer.style.transform = 'scale(1.05)';
                  buttonContainer.style.boxShadow = '0 0.06rem 0.16rem rgba(0,0,0,0.4)';
                };
                buttonContainer.onmouseout = function () {
                  buttonContainer.style.transform = 'scale(1)';
                  buttonContainer.style.boxShadow = '0 0.04rem 0.12rem rgba(0,0,0,0.3)';
                };

                // 点击事件
                buttonContainer.onclick = /*#__PURE__*/goodsDetailHelper_asyncToGenerator(/*#__PURE__*/goodsDetailHelper_regeneratorRuntime().mark(function _callee2() {
                  var currentUser;
                  return goodsDetailHelper_regeneratorRuntime().wrap(function _callee2$(_context2) {
                    while (1) switch (_context2.prev = _context2.next) {
                      case 0:
                        _context2.next = 2;
                        return getCurrentUser();
                      case 2:
                        currentUser = _context2.sent;
                        if (currentUser) {
                          _context2.next = 6;
                          break;
                        }
                        alert('请先登录后再使用商品采集功能');
                        return _context2.abrupt("return");
                      case 6:
                        if (!currentUser.isExpired) {
                          _context2.next = 9;
                          break;
                        }
                        if (currentUser.payment_model === 'pay_as_you_go') {
                          alert('多多币已到期，请联系管理员续费');
                        } else {
                          alert('套餐已过期，请续费后再使用商品采集功能');
                        }
                        return _context2.abrupt("return");
                      case 9:
                        buttonContainer.style.pointerEvents = 'none';
                        text.textContent = '采集中...';
                        _context2.prev = 11;
                        _context2.next = 14;
                        return _this7.exportToExcel();
                      case 14:
                        text.textContent = '采集成功';
                        setTimeout(function () {
                          text.textContent = '采集商品';
                          buttonContainer.style.pointerEvents = 'auto';
                        }, 2000);
                        _context2.next = 22;
                        break;
                      case 18:
                        _context2.prev = 18;
                        _context2.t0 = _context2["catch"](11);
                        text.textContent = '采集失败';
                        setTimeout(function () {
                          text.textContent = '采集商品';
                          buttonContainer.style.pointerEvents = 'auto';
                        }, 2000);
                      case 22:
                      case "end":
                        return _context2.stop();
                    }
                  }, _callee2, null, [[11, 18]]);
                }));
              } else {
                // 无权限：锁定状态
                buttonContainer.style.cssText = baseStyle + "\n                background: linear-gradient(135deg, #999 0%, #666 100%);\n                opacity: 0.8;\n            ";
                text.textContent = '采集商品 🔒';
                buttonContainer.title = '升级到专业套餐或高级套餐，解锁商品采集功能';

                // 点击跳转到升级页面
                buttonContainer.onclick = /*#__PURE__*/function () {
                  var _ref2 = goodsDetailHelper_asyncToGenerator(/*#__PURE__*/goodsDetailHelper_regeneratorRuntime().mark(function _callee3(e) {
                    var currentUser, username, upgradeUrl;
                    return goodsDetailHelper_regeneratorRuntime().wrap(function _callee3$(_context3) {
                      while (1) switch (_context3.prev = _context3.next) {
                        case 0:
                          e.preventDefault();
                          e.stopPropagation();
                          _context3.next = 4;
                          return getCurrentUser();
                        case 4:
                          currentUser = _context3.sent;
                          username = (currentUser === null || currentUser === void 0 ? void 0 : currentUser.username) || 'default_user';
                          upgradeUrl = "".concat(API_BASE_URL, "/payment-page?username=").concat(username);
                          window.open(upgradeUrl, '_blank');
                        case 8:
                        case "end":
                          return _context3.stop();
                      }
                    }, _callee3);
                  }));
                  return function (_x) {
                    return _ref2.apply(this, arguments);
                  };
                }();
              }
              buttonContainer.appendChild(text);

              // 添加到页面
              document.body.appendChild(buttonContainer);
              console.log('采集按钮已创建，权限状态:', hasPermission ? '可用' : '锁定');
            case 19:
            case "end":
              return _context4.stop();
          }
        }, _callee4);
      }));
      function createCollectButton() {
        return _createCollectButton.apply(this, arguments);
      }
      return createCollectButton;
    }()
  }]);
}(); // 初始化商品数据采集器
var goodsDataCollector = null;

// 在页面加载完成后创建采集按钮
window.addEventListener('load', function () {
  // 检查是否在商品详情页面
  var isGoodsPage = (window.location.hostname.includes('mobile.yangkeduo.com') || window.location.hostname.includes('yangkeduo.com')) && (window.location.pathname.includes('/goods') || window.location.search.includes('goods_id'));
  if (isGoodsPage) {
    console.log('初始化商品数据采集器');
    goodsDataCollector = new GoodsDataCollector();

    // 等待rawData加载后创建按钮
    var checkRawData = setInterval(function () {
      if (window.rawData && window.rawData.store && window.rawData.store.initDataObj) {
        clearInterval(checkRawData);
        console.log('检测到 window.rawData，创建采集按钮');
        goodsDataCollector.createCollectButton();
      }
    }, 500);

    // 30秒后停止检查
    setTimeout(function () {
      clearInterval(checkRawData);
      if (!window.rawData || !window.rawData.store || !window.rawData.store.initDataObj) {
        console.log('未检测到 window.rawData，不显示采集按钮');
      }
    }, 30000);
  }
});

// 导出采集器供外部使用
window.GoodsDataCollector = GoodsDataCollector;
console.log('商品详情助手脚本初始化完成');
console.log('可以在控制台运行 window.debugGoodsHelper() 进行调试');
/******/ })()
;