/******/ (() => { // webpackBootstrap
/**
 * QR码页面替换脚本 - 简化版本
 * 直接使用API在img标签中显示二维码
 */

// 提供给外部调用的函数
window.initQRCodeWithUrl = function (url) {
  initQRCodeInternal(url);
};

// 内部初始化函数
function initQRCodeInternal(url) {
  // 防止重复注入
  if (window.qrCodePageReplaced) {
    console.log('页面已替换为二维码页面，跳过');
    return;
  }
  window.qrCodePageReplaced = true;
  console.log('开始替换页面为二维码页面，URL:', url);
  try {
    // 移除任何可能存在的手机扫码按钮
    var existingButton = document.getElementById('mobileScanPayButton');
    if (existingButton) {
      existingButton.remove();
    }

    // 直接生成二维码URL
    var qrCodeUrl = "https://qun.qq.com/qrcode/index?data=" + encodeURIComponent(url);

    // 替换整个页面内容
    document.documentElement.innerHTML = "\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>\u652F\u4ED8\u5B9D\u626B\u7801\u652F\u4ED8</title>\n        <style>\n          body {\n            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;\n            margin: 0; padding: 20px; background: #f5f5f5; text-align: center;\n            min-height: 100vh; box-sizing: border-box;\n          }\n          .container {\n            background: white; border-radius: 12px; padding: 30px 20px;\n            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); max-width: 400px; margin: 50px auto;\n          }\n          .header {\n            color: #333; font-size: 24px; font-weight: 600; margin-bottom: 20px;\n            display: flex; align-items: center; justify-content: center; gap: 8px;\n          }\n          .logo {\n            width: 32px; height: 32px; background: linear-gradient(45deg, #1677ff, #69c0ff);\n            border-radius: 8px; display: inline-flex; align-items: center;\n            justify-content: center; color: white; font-weight: bold; font-size: 16px;\n          }\n          #qrcode {\n            margin: 20px auto; padding: 20px; border: 2px dashed #e6f3ff;\n            border-radius: 12px; background: #fafcff;\n            min-width: 200px; min-height: 180px; position: relative;\n          }\n          .loading {\n            display: flex; flex-direction: column; align-items: center; justify-content: center;\n            min-height: 180px; color: #666; font-size: 14px; gap: 10px;\n          }\n          .spinner {\n            width: 24px; height: 24px; border: 3px solid #e6e6e6;\n            border-top: 3px solid #1677ff; border-radius: 50%; \n            animation: spin 1s linear infinite;\n          }\n          @keyframes spin { \n            0% { transform: rotate(0deg); } \n            100% { transform: rotate(360deg); } \n          }\n          .qr-image {\n            width: 180px; height: 180px; border-radius: 8px; display: none; margin: 0 auto;\n          }\n          .fallback {\n            display: flex; flex-direction: column; align-items: center; justify-content: center; \n            min-height: 180px; padding: 20px;\n          }\n          .fallback-link {\n            background: #1677ff; color: white; padding: 12px 24px; border-radius: 8px; \n            text-decoration: none; font-size: 14px;\n          }\n          .fallback-link:hover {\n            background: #0958d9;\n          }\n          .instruction { \n            color: #666; font-size: 14px; line-height: 1.8; margin: 25px 0; \n            background: #f8f9fa; padding: 15px; border-radius: 8px;\n          }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <div class=\"logo\">\u652F</div>\n            \u652F\u4ED8\u5B9D\u626B\u7801\u652F\u4ED8\n          </div>\n          <div id=\"qrcode\">\n            <div class=\"loading\">\n              <div class=\"spinner\"></div>\n              \u6B63\u5728\u751F\u6210\u4E8C\u7EF4\u7801...\n            </div>\n            <img src=\"".concat(qrCodeUrl, "\" class=\"qr-image\" alt=\"\u652F\u4ED8\u4E8C\u7EF4\u7801\" \n                 onload=\"this.style.display='block'; this.previousElementSibling.style.display='none';\"\n                 onerror=\"this.previousElementSibling.style.display='none'; this.nextElementSibling.style.display='flex';\" />\n            <div class=\"fallback\" style=\"display: none;\">\n              <div style=\"font-size: 16px; color: #333; margin-bottom: 15px; font-weight: 500;\">\u8BF7\u70B9\u51FB\u4E0B\u65B9\u94FE\u63A5\u5B8C\u6210\u652F\u4ED8</div>\n              <a href=\"").concat(url, "\" target=\"_blank\" class=\"fallback-link\">\u6253\u5F00\u652F\u4ED8\u5B9D\u652F\u4ED8</a>\n              <div style=\"margin-top: 10px; font-size: 12px; color: #999;\">\u6216\u590D\u5236\u94FE\u63A5\u5728\u624B\u673A\u6D4F\u89C8\u5668\u4E2D\u6253\u5F00</div>\n            </div>\n          </div>\n          <div class=\"instruction\">\n            <div>1. \u4F7F\u7528\u624B\u673A\u76F8\u673A\u626B\u63CF\u4E0A\u65B9\u4E8C\u7EF4\u7801</div>\n            <div>2. \u5728\u624B\u673A\u6D4F\u89C8\u5668\u4E2D\u6253\u5F00\u94FE\u63A5\u5730\u5740</div>\n            <div>3. \u8DF3\u8F6C\u5230\u652F\u4ED8\u5B9DAPP\u4E2D\u5B8C\u6210\u652F\u4ED8</div>\n          </div>\n        </div>\n      </body>\n    ");
    console.log('支付宝页面已替换为二维码页面');
  } catch (error) {
    console.error('替换页面内容失败:', error);
  }
}

// 自动初始化函数（已禁用，改为按钮触发）
function initQRCode() {
  var urlParams = new URLSearchParams(window.location.search);
  var alipayUrl = window.alipayPaymentUrl || urlParams.get('url') || window.location.href;
  initQRCodeInternal(alipayUrl);
}

// 注释掉自动执行逻辑，改为只能通过按钮触发
// if (document.readyState === 'loading') {
//   document.addEventListener('DOMContentLoaded', initQRCode);
// } else {
//   setTimeout(initQRCode, 50);
// }
/******/ })()
;