/******/ (() => { // webpackBootstrap
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
// 再次拼单自动化助手 - 合并确定按钮点击和下单页面处理
console.log('[再次拼单自动化助手] 脚本已加载');

// === 确定按钮点击功能 ===
var confirmCheckInterval;
var confirmClickAttempts = 0;
var MAX_CONFIRM_ATTEMPTS = 30; // 最多尝试30次，每次间隔1秒

function startCheckingConfirmButton() {
  console.log('[再次拼单助手] 开始检测确定按钮');
  confirmCheckInterval = setInterval(function () {
    confirmClickAttempts++;
    if (confirmClickAttempts > MAX_CONFIRM_ATTEMPTS) {
      console.log('[再次拼单助手] 超过最大检测次数，停止检测');
      clearInterval(confirmCheckInterval);
      return;
    }

    // 检测并点击确定按钮
    if (findAndClickConfirmButton()) {
      console.log('[再次拼单助手] 成功点击确定按钮，停止检测');
      clearInterval(confirmCheckInterval);
    }
  }, 1000);
}
function findAndClickConfirmButton() {
  try {
    // 方法1: 通过aria-label和role属性查找（最常见的方式）
    var confirmButton = null;
    try {
      var ariaButtons = document.querySelectorAll('[aria-label="确定"][role="button"]');
      var _iterator = _createForOfIteratorHelper(ariaButtons),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var button = _step.value;
          if (button.offsetParent !== null) {
            // 确保按钮可见
            confirmButton = button;
            console.log('[再次拼单助手] 方法1找到确定按钮（aria-label + role）');
            break;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    } catch (e) {
      console.warn('[再次拼单助手] 方法1失败:', e);
    }

    // 方法2: 通过特定的class名称查找
    if (!confirmButton) {
      try {
        var classSelectors = ['[data-active="red"]',
        // 用户提到的属性
        '.confirm-btn', '.order-confirm', '.btn-confirm'];
        for (var _i = 0, _classSelectors = classSelectors; _i < _classSelectors.length; _i++) {
          var selector = _classSelectors[_i];
          var elements = document.querySelectorAll(selector);
          var _iterator2 = _createForOfIteratorHelper(elements),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var element = _step2.value;
              if (element.textContent && element.textContent.trim() === '确定' && element.offsetParent !== null) {
                confirmButton = element;
                console.log("[\u518D\u6B21\u62FC\u5355\u52A9\u624B] \u65B9\u6CD52\u627E\u5230\u786E\u5B9A\u6309\u94AE\uFF08".concat(selector, "\uFF09"));
                break;
              }
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
          if (confirmButton) break;
        }
      } catch (e) {
        console.warn('[再次拼单助手] 方法2失败:', e);
      }
    }

    // 方法3: 通过XPath查找（原有方法）
    if (!confirmButton) {
      try {
        var xpathResult = document.evaluate('//*[@id="main"]/div/div[2]/div[21]/div/div/div[4]', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
        confirmButton = xpathResult.singleNodeValue;
        if (confirmButton && confirmButton.offsetParent !== null) {
          console.log('[再次拼单助手] 方法3找到确定按钮（XPath）');
        } else {
          confirmButton = null;
        }
      } catch (e) {
        console.warn('[再次拼单助手] 方法3失败:', e);
      }
    }

    // 方法4: 通过组合属性查找
    if (!confirmButton) {
      try {
        var combinedSelectors = ['[aria-label="确定"]', '[role="button"][data-active="red"]', 'div[role="button"]:contains("确定")'];
        for (var _i2 = 0, _combinedSelectors = combinedSelectors; _i2 < _combinedSelectors.length; _i2++) {
          var _selector = _combinedSelectors[_i2];
          try {
            var _elements = document.querySelectorAll(_selector);
            var _iterator3 = _createForOfIteratorHelper(_elements),
              _step3;
            try {
              for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                var _element = _step3.value;
                var text = _element.textContent && _element.textContent.trim();
                if ((text === '确定' || _element.getAttribute('aria-label') === '确定') && _element.offsetParent !== null) {
                  confirmButton = _element;
                  console.log("[\u518D\u6B21\u62FC\u5355\u52A9\u624B] \u65B9\u6CD54\u627E\u5230\u786E\u5B9A\u6309\u94AE\uFF08".concat(_selector, "\uFF09"));
                  break;
                }
              }
            } catch (err) {
              _iterator3.e(err);
            } finally {
              _iterator3.f();
            }
            if (confirmButton) break;
          } catch (e) {
            continue;
          }
        }
      } catch (e) {
        console.warn('[再次拼单助手] 方法4失败:', e);
      }
    }

    // 方法5: 通过文本内容广泛查找所有可能的按钮元素
    if (!confirmButton) {
      try {
        var allButtons = document.querySelectorAll('div[role="button"], button, .btn, [onclick], [data-click]');
        var _iterator4 = _createForOfIteratorHelper(allButtons),
          _step4;
        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var _button = _step4.value;
            var _text = _button.textContent && _button.textContent.trim();
            var ariaLabel = _button.getAttribute('aria-label');
            if ((_text === '确定' || ariaLabel === '确定') && _button.offsetParent !== null && !_button.disabled) {
              confirmButton = _button;
              console.log('[再次拼单助手] 方法5找到确定按钮（广泛文本搜索）');
              break;
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      } catch (e) {
        console.warn('[再次拼单助手] 方法5失败:', e);
      }
    }

    // 方法6: 最后的兜底方案 - 查找所有包含"确定"文本的可见元素
    if (!confirmButton) {
      try {
        var allElements = document.querySelectorAll('*');
        var _iterator5 = _createForOfIteratorHelper(allElements),
          _step5;
        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var _element2 = _step5.value;
            if (_element2.textContent && _element2.textContent.trim() === '确定' && _element2.offsetParent !== null && (_element2.onclick || _element2.addEventListener || _element2.style.cursor === 'pointer' || _element2.getAttribute('role') === 'button' || _element2.tagName.toLowerCase() === 'button')) {
              confirmButton = _element2;
              console.log('[再次拼单助手] 方法6找到确定按钮（兜底方案）');
              break;
            }
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }
      } catch (e) {
        console.warn('[再次拼单助手] 方法6失败:', e);
      }
    }
    if (confirmButton && confirmButton.offsetParent !== null) {
      console.log('[再次拼单助手] 找到确定按钮，准备点击:', confirmButton);

      // 尝试点击
      try {
        confirmButton.click();
        console.log('[再次拼单助手] 已点击确定按钮');

        // 通知父窗口点击成功
        try {
          // 发送给opener（主要的通信方式）
          if (window.opener && window.opener !== window && !window.opener.closed) {
            window.opener.postMessage({
              type: 'REORDER_CONFIRM_CLICKED',
              success: true
            }, '*');
            console.log('[再次拼单助手] 已通知opener点击成功');
          }

          // 同时发送给parent（备用方式）
          if (window.parent && window.parent !== window) {
            window.parent.postMessage({
              type: 'REORDER_CONFIRM_CLICKED',
              success: true
            }, '*');
            console.log('[再次拼单助手] 已通知parent点击成功');
          }

          // 发送给top窗口（再备用）
          if (window.top && window.top !== window) {
            window.top.postMessage({
              type: 'REORDER_CONFIRM_CLICKED',
              success: true
            }, '*');
            console.log('[再次拼单助手] 已通知top点击成功');
          }
        } catch (e) {
          console.warn('[再次拼单助手] 发送通知消息失败:', e);
        }
        return true;
      } catch (clickError) {
        console.error('[再次拼单助手] 点击确定按钮失败:', clickError);
      }
    } else {
      console.log('[再次拼单助手] 未找到可见的确定按钮');
    }
    return false;
  } catch (error) {
    console.error('[再次拼单助手] 查找确定按钮时出错:', error);
    return false;
  }
}

// === 下单页面处理功能 ===

// 检查是否为再次拼单场景
function isReorderCheckout() {
  // 方法1: 检查URL参数
  var urlParams = new URLSearchParams(window.location.search);
  if (urlParams.has('from_reorder') || urlParams.has('reorder_batch_id')) {
    console.log('[再次拼单检测] 通过URL参数检测到再次拼单场景');
    return true;
  }

  // 方法2: 检查referrer是否来自再次拼单
  if (document.referrer && (document.referrer.includes('from_reorder=1') || document.referrer.includes('goods.html'))) {
    console.log('[再次拼单检测] 通过referrer检测到再次拼单场景');
    return true;
  }

  // 方法3: 检查是否包含旧的reorder参数
  if (urlParams.has('reorder')) {
    console.log('[再次拼单检测] 通过reorder参数检测到再次拼单场景');
    return true;
  }
  console.log('[再次拼单检测] 未检测到再次拼单场景');
  return false;
}

// 检查是否为再次拼单的确定按钮页面场景
function isReorderConfirmPage() {
  // 方法1: 检查URL参数中是否有再次拼单标识且当前是goods.html页面
  var urlParams = new URLSearchParams(window.location.search);
  var isGoodsPage = window.location.pathname.includes('goods.html');
  if (isGoodsPage && (urlParams.has('from_reorder') || urlParams.has('reorder_batch_id'))) {
    console.log('[再次拼单确定页面检测] 通过URL参数检测到再次拼单确定页面场景');
    return true;
  }

  // 方法2: 检查referrer是否来自再次拼单且当前是goods.html
  if (isGoodsPage && document.referrer && (document.referrer.includes('from_reorder=1') || document.referrer.includes('reorder_batch_id'))) {
    console.log('[再次拼单确定页面检测] 通过referrer检测到再次拼单确定页面场景');
    return true;
  }

  // 方法4: 如果是goods.html页面但没有再次拼单标识，说明可能是其他场景（如商品ID提取脚本）
  if (isGoodsPage) {
    console.log('[再次拼单确定页面检测] 检测到goods.html页面但无再次拼单标识，可能是其他场景');
    return false;
  }

  // 方法5: 非goods.html页面，检查是否有确定按钮（可能是弹窗场景）
  var hasConfirmButton = document.querySelector('[aria-label="确定"][role="button"]') || document.querySelector('[data-active="red"]');
  if (hasConfirmButton) {
    console.log('[再次拼单确定页面检测] 检测到确定按钮，可能是再次拼单确定页面');
    return true;
  }
  console.log('[再次拼单确定页面检测] 未检测到再次拼单确定页面场景');
  return false;
}

// 下单页面处理
var checkoutCheckInterval;
var submitAttempts = 0;
var MAX_SUBMIT_ATTEMPTS = 20; // 减少到20次，总时间20秒

function startReorderCheckout() {
  console.log('[再次拼单下单助手] 开始处理再次拼单下单');
  checkoutCheckInterval = setInterval(function () {
    submitAttempts++;
    if (submitAttempts > MAX_SUBMIT_ATTEMPTS) {
      console.log('[再次拼单下单助手] 超过最大处理次数，停止处理');
      clearInterval(checkoutCheckInterval);
      notifyResult(false, '处理超时');
      return;
    }

    // 检测并提交订单
    if (findAndSubmitOrder()) {
      console.log('[再次拼单下单助手] 成功提交订单，停止处理');
      clearInterval(checkoutCheckInterval);
    }
  }, 1000); // 改为每1秒检查一次，提高响应速度
}
function findAndSubmitOrder() {
  try {
    // 检查页面是否完全加载
    if (document.readyState !== 'complete') {
      return false;
    }
    console.log('[再次拼单下单助手] 开始查找提交按钮');

    // 获取订单金额（用于结果报告）- 使用与多地址下单相同的方法
    var orderAmount = '未获取';
    try {
      console.log('[再次拼单下单助手] 💰 开始解析实付款金额...');

      // 方法1: 查找实付款元素的aria-label属性
      var paymentElements = document.querySelectorAll('div[role="button"]');
      var _iterator6 = _createForOfIteratorHelper(paymentElements),
        _step6;
      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var _element3 = _step6.value;
          var ariaLabel = _element3.getAttribute('aria-label');
          if (ariaLabel && ariaLabel.includes('实付款')) {
            console.log('[再次拼单下单助手] 💰 找到实付款元素，aria-label:', ariaLabel);

            // 从aria-label中提取金额：实付款¥4.8免运费 -> 4.8
            var _match = ariaLabel.match(/实付款¥?([0-9]+(?:\.[0-9]+)?)/);
            if (_match) {
              var _amount = parseFloat(_match[1]);
              console.log('[再次拼单下单助手] 💰 从aria-label解析出实付款金额:', _amount);
              orderAmount = "\xA5".concat(_amount);
              break;
            }
          }
        }

        // 方法2: 备用方案，查找包含实付款文本的元素
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
      if (orderAmount === '未获取') {
        var allElements = document.querySelectorAll('*');
        var _iterator7 = _createForOfIteratorHelper(allElements),
          _step7;
        try {
          for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
            var element = _step7.value;
            var text = element.textContent || '';
            if (text.includes('实付款') && text.includes('¥')) {
              console.log('[再次拼单下单助手] 💰 找到包含实付款的元素:', text);

              // 尝试提取金额
              var match = text.match(/实付款[：:]?\s*¥?([0-9]+(?:\.[0-9]+)?)/);
              if (match) {
                var amount = parseFloat(match[1]);
                console.log('[再次拼单下单助手] 💰 从文本内容解析出实付款金额:', amount);
                orderAmount = "\xA5".concat(amount);
                break;
              }
            }
          }
        } catch (err) {
          _iterator7.e(err);
        } finally {
          _iterator7.f();
        }
      }
      if (orderAmount === '未获取') {
        console.log('[再次拼单下单助手] 💰 ⚠️ 未找到实付款金额元素');
      }
    } catch (e) {
      console.warn('[再次拼单下单助手] 获取订单金额失败:', e);
    }

    // 查找提交订单按钮 - 优化查找逻辑，按优先级排序
    var submitButton = null;

    // 方法1: 优先查找最常见的提交按钮（按优先级排序）
    var primarySelectors = ['button[type="submit"]', '.submit-btn', '.checkout-btn', '.pay-btn'];
    for (var _i3 = 0, _primarySelectors = primarySelectors; _i3 < _primarySelectors.length; _i3++) {
      var selector = _primarySelectors[_i3];
      try {
        var elements = document.querySelectorAll(selector);
        var _iterator8 = _createForOfIteratorHelper(elements),
          _step8;
        try {
          for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
            var _element4 = _step8.value;
            if (_element4 && _element4.offsetParent !== null && !_element4.disabled) {
              submitButton = _element4;
              console.log("[\u518D\u6B21\u62FC\u5355\u4E0B\u5355\u52A9\u624B] \u901A\u8FC7\u4E3B\u8981\u9009\u62E9\u5668\u627E\u5230\u63D0\u4EA4\u6309\u94AE: ".concat(selector));
              break;
            }
          }
        } catch (err) {
          _iterator8.e(err);
        } finally {
          _iterator8.f();
        }
        if (submitButton) break;
      } catch (e) {
        continue;
      }
    }

    // 方法2: 如果没找到，通过文本查找（优化文本匹配）
    if (!submitButton) {
      var buttons = document.querySelectorAll('button, div[role="button"], .btn, [onclick]');
      var _iterator9 = _createForOfIteratorHelper(buttons),
        _step9;
      try {
        for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
          var _button$textContent;
          var button = _step9.value;
          if (!button.offsetParent || button.disabled) continue;
          var _text2 = ((_button$textContent = button.textContent) === null || _button$textContent === void 0 ? void 0 : _button$textContent.trim()) || '';
          var _ariaLabel = button.getAttribute('aria-label') || '';

          // 精确匹配常见的提交按钮文本
          if (_text2 === '提交订单' || _text2 === '立即支付' || _text2 === '确认下单' || _text2 === '去支付' || _ariaLabel.includes('提交') || _ariaLabel.includes('支付')) {
            submitButton = button;
            console.log("[\u518D\u6B21\u62FC\u5355\u4E0B\u5355\u52A9\u624B] \u901A\u8FC7\u6587\u672C\u5339\u914D\u627E\u5230\u63D0\u4EA4\u6309\u94AE: \"".concat(_text2 || _ariaLabel, "\""));
            break;
          }
        }
      } catch (err) {
        _iterator9.e(err);
      } finally {
        _iterator9.f();
      }
    }
    if (!submitButton) {
      console.log('[再次拼单下单助手] 未找到提交按钮，继续等待');
      return false;
    }
    console.log('[再次拼单下单助手] 找到提交按钮，准备提交订单');

    // 点击提交按钮
    try {
      submitButton.click();
      console.log('[再次拼单下单助手] 已点击提交按钮');

      // 与多地址下单保持一致：快速通知订单提交成功
      console.log('[再次拼单下单助手] 快速通知订单提交成功');
      setTimeout(function () {
        notifyResult(true, '订单提交成功', orderAmount);
      }, 300); // 减少延迟到300ms

      return true;
    } catch (clickError) {
      console.error('[再次拼单下单助手] 点击提交按钮失败:', clickError);
      notifyResult(false, '点击提交按钮失败');
      return false;
    }
  } catch (error) {
    console.error('[再次拼单下单助手] 查找提交按钮时出错:', error);
    return false;
  }
}

// 通知结果给父窗口 - 使用与多地址下单相同的消息格式
function notifyResult(success, message) {
  var amount = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '未获取';
  try {
    // 使用与多地址下单相同的消息格式和结构
    var messageData = {
      success: success,
      message: message,
      actualPayment: amount,
      orderIndex: 0 // 再次拼单场景下的订单索引
    };
    var messagePayload = {
      type: 'multiAddressAutomation',
      // 使用与多地址下单相同的消息类型
      action: success ? 'ORDER_SUBMITTED_SUCCESS' : 'order_submit_failed',
      data: messageData
    };

    // 发送到opener
    if (window.opener && window.opener !== window && !window.opener.closed) {
      console.log('[再次拼单下单助手] 向opener发送消息:', JSON.stringify(messagePayload));
      window.opener.postMessage(messagePayload, '*');
      console.log('[再次拼单下单助手] opener消息发送成功');
    } else {
      console.log('[再次拼单下单助手] opener不存在或已关闭');
    }

    // 发送到parent
    if (window.parent && window.parent !== window) {
      console.log('[再次拼单下单助手] 向parent发送消息:', JSON.stringify(messagePayload));
      window.parent.postMessage(messagePayload, '*');
      console.log('[再次拼单下单助手] parent消息发送成功');
    } else {
      console.log('[再次拼单下单助手] 当前窗口就是顶级窗口，无parent');
    }

    // 同时发送到顶级窗口
    if (window.top && window.top !== window) {
      console.log('[再次拼单下单助手] 向top发送消息:', JSON.stringify(messagePayload));
      window.top.postMessage(messagePayload, '*');
      console.log('[再次拼单下单助手] top消息发送成功');
    } else {
      console.log('[再次拼单下单助手] 当前窗口就是顶级窗口');
    }
  } catch (error) {
    console.error('[再次拼单下单助手] 发送消息失败:', error);
  }
}

// === 初始化和事件监听 ===

// 页面加载完成后的初始化逻辑
function initializeReorderAutomation() {
  console.log('[再次拼单自动化助手] 开始初始化');
  console.log('[再次拼单自动化助手] 当前URL:', window.location.href);
  console.log('[再次拼单自动化助手] Referrer:', document.referrer);

  // 检查是否为下单页面（再次拼单场景）
  if (isReorderCheckout()) {
    console.log('[再次拼单下单助手] 检测到再次拼单下单场景，开始自动下单');
    setTimeout(startReorderCheckout, 2000); // 减少等待时间到2秒
  }
  // 检查是否为确定按钮页面（再次拼单场景）
  else if (isReorderConfirmPage()) {
    console.log('[再次拼单助手] 检测到再次拼单确定按钮页面，开始检测确定按钮');
    setTimeout(startCheckingConfirmButton, 1000); // 减少等待时间到1秒
  } else {
    console.log('[再次拼单助手] 未检测到再次拼单场景，跳过自动化处理');
    console.log('[再次拼单助手] 如果需要手动触发，请通过消息事件启动');
  }
}

// 页面加载完成后开始处理
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initializeReorderAutomation);
} else {
  initializeReorderAutomation();
}

// 监听来自父窗口的消息
window.addEventListener('message', function (event) {
  if (event.data && event.data.type === 'START_REORDER_CHECK') {
    console.log('[再次拼单助手] 收到开始检测确定按钮指令');
    startCheckingConfirmButton();
  } else if (event.data && event.data.type === 'START_REORDER_CHECKOUT') {
    console.log('[再次拼单下单助手] 收到开始下单指令');
    startReorderCheckout();
  }
});

// 页面卸载时清理定时器
window.addEventListener('beforeunload', function () {
  if (confirmCheckInterval) {
    clearInterval(confirmCheckInterval);
  }
  if (checkoutCheckInterval) {
    clearInterval(checkoutCheckInterval);
  }
});
/******/ })()
;